/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.SoyNode;

public final class IfCondNode
extends AbstractBlockCommandNode
implements SoyNode.ConditionalBlockNode,
SoyNode.ExprHolderNode {
    private final ExprRootNode expr;

    public IfCondNode(int id, SourceLocation location, SourceLocation openTagLocation, String commandName, ExprNode expr) {
        super(id, location, openTagLocation, commandName);
        Preconditions.checkArgument((commandName.equals("if") || commandName.equals("elseif") ? 1 : 0) != 0);
        this.expr = new ExprRootNode(expr);
    }

    private IfCondNode(IfCondNode orig, CopyState copyState) {
        super(orig, copyState);
        this.expr = orig.expr.copy(copyState);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.IF_COND_NODE;
    }

    public ExprRootNode getExpr() {
        return this.expr;
    }

    @Override
    public String getCommandName() {
        return this.getParent().getChild(0) == this ? "if" : "elseif";
    }

    @Override
    public String getCommandText() {
        return this.expr.toSourceString();
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTagString());
        this.appendSourceStringForChildren(sb);
        return sb.toString();
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.expr);
    }

    @Override
    public IfCondNode copy(CopyState copyState) {
        return new IfCondNode(this, copyState);
    }
}

