/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.MixinParentNode;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.Optional;

public final class CallParamContentNode
extends CallParamNode
implements SoyNode.RenderUnitNode,
CommandTagAttribute.CommandTagAttributesHolder {
    private final MixinParentNode<SoyNode.StandaloneNode> parentMixin;
    private final SanitizedContentKind contentKind;
    private final SourceLocation openTagLocation;
    private final CommandTagAttribute kindAttr;

    public CallParamContentNode(int id, SourceLocation location, SourceLocation openTagLocation, Identifier key, CommandTagAttribute kindAttr, ErrorReporter errorReporter) {
        super(id, location, key);
        this.parentMixin = new MixinParentNode<SoyNode.StandaloneNode>(this);
        Optional<Object> parsedKind = Optional.empty();
        if (!kindAttr.hasName("kind")) {
            errorReporter.report(kindAttr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY_SINGLE, kindAttr.getName().identifier(), "param", "kind");
        } else {
            parsedKind = kindAttr.valueAsContentKind(errorReporter);
        }
        this.kindAttr = kindAttr;
        this.contentKind = parsedKind.orElse((Object)SanitizedContentKind.HTML);
        this.openTagLocation = openTagLocation;
    }

    private CallParamContentNode(CallParamContentNode orig, CopyState copyState) {
        super(orig, copyState);
        this.parentMixin = new MixinParentNode<SoyNode.StandaloneNode>(orig.parentMixin, this, copyState);
        this.contentKind = orig.contentKind;
        this.openTagLocation = orig.openTagLocation;
        this.kindAttr = orig.kindAttr.copy(copyState);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_PARAM_CONTENT_NODE;
    }

    @Override
    public SanitizedContentKind getContentKind() {
        return this.contentKind;
    }

    @Override
    public String getCommandText() {
        return this.contentKind == null ? this.getKey().identifier() : this.getKey().identifier() + " kind=\"" + this.contentKind.asAttributeValue() + "\"";
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTagString());
        this.appendSourceStringForChildren(sb);
        sb.append("{/").append(this.getCommandName()).append('}');
        return sb.toString();
    }

    public ImmutableList<CommandTagAttribute> getAttributes() {
        return ImmutableList.of((Object)this.kindAttr);
    }

    @Override
    public CallParamContentNode copy(CopyState copyState) {
        return new CallParamContentNode(this, copyState);
    }

    @Override
    public int numChildren() {
        return this.parentMixin.numChildren();
    }

    @Override
    public SoyNode.StandaloneNode getChild(int index) {
        return this.parentMixin.getChild(index);
    }

    @Override
    public int getChildIndex(Node child) {
        return this.parentMixin.getChildIndex(child);
    }

    @Override
    public List<SoyNode.StandaloneNode> getChildren() {
        return this.parentMixin.getChildren();
    }

    @Override
    public void addChild(SoyNode.StandaloneNode child) {
        this.parentMixin.addChild(child);
    }

    @Override
    public void addChild(int index, SoyNode.StandaloneNode child) {
        this.parentMixin.addChild(index, child);
    }

    @Override
    public void removeChild(int index) {
        this.parentMixin.removeChild(index);
    }

    @Override
    public void removeChild(SoyNode.StandaloneNode child) {
        this.parentMixin.removeChild(child);
    }

    @Override
    public void replaceChild(int index, SoyNode.StandaloneNode newChild) {
        this.parentMixin.replaceChild((SoyNode.StandaloneNode)index, newChild);
    }

    @Override
    public void replaceChild(SoyNode.StandaloneNode currChild, SoyNode.StandaloneNode newChild) {
        this.parentMixin.replaceChild(currChild, newChild);
    }

    @Override
    public void clearChildren() {
        this.parentMixin.clearChildren();
    }

    @Override
    public void addChildren(List<? extends SoyNode.StandaloneNode> children) {
        this.parentMixin.addChildren(children);
    }

    @Override
    public void addChildren(int index, List<? extends SoyNode.StandaloneNode> children) {
        this.parentMixin.addChildren(index, children);
    }

    @Override
    public void appendSourceStringForChildren(StringBuilder sb) {
        this.parentMixin.appendSourceStringForChildren(sb);
    }

    @Override
    public SourceLocation getOpenTagLocation() {
        return this.openTagLocation;
    }
}

