/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class CallDelegateNode
extends CallNode {
    private static final SoyErrorKind INVALID_VARIANT_EXPRESSION = SoyErrorKind.of("Invalid variant expression \"{0}\" in ''delcall'' (variant expression must evaluate to an identifier).", new SoyErrorKind.StyleAllowance[0]);
    private final Identifier sourceDelCalleeName;
    private final String delCalleeName;
    @Nullable
    private final ExprRootNode variantExpr;
    private final boolean allowEmptyDefault;
    @Nullable
    private ImmutableMap<String, Predicate<String>> paramsToRuntimeCheckByDelegate = null;

    public CallDelegateNode(int id, SourceLocation location, SourceLocation openTagLocation, Identifier delCalleeName, List<CommandTagAttribute> attributes, boolean selfClosing, ErrorReporter errorReporter) {
        super(id, location, openTagLocation, "delcall", attributes, selfClosing, errorReporter);
        this.delCalleeName = delCalleeName.identifier();
        this.sourceDelCalleeName = delCalleeName;
        ExprRootNode variantExpr = null;
        boolean allowEmptyDefault = false;
        block13: for (CommandTagAttribute attr : attributes) {
            String name;
            switch (name = attr.getName().identifier()) {
                case "data": 
                case "key": 
                case "phname": 
                case "phex": {
                    continue block13;
                }
                case "variant": {
                    ExprRootNode value = attr.valueAsExpr(errorReporter);
                    if (value.getRoot() instanceof StringNode) {
                        String variantStr = ((StringNode)value.getRoot()).getValue();
                        if (!BaseUtils.isIdentifier(variantStr)) {
                            errorReporter.report(location, INVALID_VARIANT_EXPRESSION, variantStr);
                        }
                    } else if (value.getRoot() instanceof ExprNode.PrimitiveNode) {
                        errorReporter.report(location, INVALID_VARIANT_EXPRESSION, value.toSourceString());
                    }
                    variantExpr = value;
                    continue block13;
                }
                case "allowemptydefault": {
                    allowEmptyDefault = attr.valueAsEnabled(errorReporter);
                    continue block13;
                }
            }
            errorReporter.report(attr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, name, "call", ImmutableList.of((Object)"data", (Object)"key", (Object)"phname", (Object)"phex", (Object)"variant", (Object)"allowemptydefault"));
        }
        this.variantExpr = variantExpr;
        this.allowEmptyDefault = allowEmptyDefault;
    }

    private CallDelegateNode(CallDelegateNode orig, CopyState copyState) {
        super(orig, copyState);
        this.delCalleeName = orig.delCalleeName;
        this.sourceDelCalleeName = orig.sourceDelCalleeName;
        this.variantExpr = orig.variantExpr != null ? orig.variantExpr.copy(copyState) : null;
        this.allowEmptyDefault = orig.allowEmptyDefault;
        this.paramsToRuntimeCheckByDelegate = orig.paramsToRuntimeCheckByDelegate;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_DELEGATE_NODE;
    }

    public String getDelCalleeName() {
        return this.delCalleeName;
    }

    @Override
    public SourceLocation getSourceCalleeLocation() {
        return this.sourceDelCalleeName.location();
    }

    @Nullable
    public ExprRootNode getDelCalleeVariantExpr() {
        return this.variantExpr;
    }

    public void setParamsToRuntimeCheck(ImmutableMap<String, Predicate<String>> paramsToRuntimeCheck) {
        Preconditions.checkState((this.paramsToRuntimeCheckByDelegate == null ? 1 : 0) != 0);
        this.paramsToRuntimeCheckByDelegate = (ImmutableMap)Preconditions.checkNotNull(paramsToRuntimeCheck);
    }

    @Override
    public Predicate<String> getParamsToRuntimeCheck(String calleeTemplateName) {
        if (this.paramsToRuntimeCheckByDelegate == null) {
            return arg -> true;
        }
        Predicate params = (Predicate)this.paramsToRuntimeCheckByDelegate.get((Object)calleeTemplateName);
        if (params == null) {
            return arg -> true;
        }
        return params;
    }

    public boolean allowEmptyDefault() {
        return this.allowEmptyDefault;
    }

    @Override
    public String getCommandText() {
        StringBuilder commandText = new StringBuilder(this.delCalleeName);
        if (this.isPassingAllData()) {
            commandText.append(" data=\"all\"");
        } else if (this.getDataExpr() != null) {
            commandText.append(" data=\"").append(this.getDataExpr().toSourceString()).append('\"');
        }
        this.getPlaceholder().userSuppliedName().ifPresent(phname -> commandText.append(" phname=\"").append((String)phname).append('\"'));
        this.getPlaceholder().example().ifPresent(phex -> commandText.append(" phex=\"").append((String)phex).append('\"'));
        if (this.variantExpr != null) {
            commandText.append(" variant=\"").append(this.variantExpr.toSourceString()).append('\"');
        }
        if (this.allowEmptyDefault) {
            commandText.append(" allowemptydefault=\"true\"");
        }
        return commandText.toString();
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        ImmutableList.Builder allExprs = ImmutableList.builder();
        if (this.variantExpr != null) {
            allExprs.add((Object)this.variantExpr);
        }
        allExprs.addAll(super.getExprList());
        return allExprs.build();
    }

    @Override
    public CallDelegateNode copy(CopyState copyState) {
        return new CallDelegateNode(this, copyState);
    }
}

