/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.data.Flags;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.TofuTemplateValue;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.SoyString;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.sharedpasses.render.EvalVisitor;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.UnionType;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TofuTypeChecks {
    private static final Logger logger = Logger.getLogger(TofuTypeChecks.class.getName());
    private static final CheckResult PASS = new CheckResult(true, Optional.empty());
    private static final CheckResult FAIL = new CheckResult(false, Optional.empty());

    public static boolean isInstance(SoyType type, SoyValue value, SourceLocation location) {
        CheckResult result = TofuTypeChecks.doIsInstance(type, value, location);
        if (result.result) {
            result.onPass.ifPresent(Runnable::run);
            return true;
        }
        return false;
    }

    private static CheckResult doIsInstance(SoyType type, SoyValue value, SourceLocation location) {
        switch (type.getKind()) {
            case ANY: 
            case UNKNOWN: {
                return PASS;
            }
            case ATTRIBUTES: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.ATTRIBUTES);
            }
            case CSS: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.CSS);
            }
            case BOOL: {
                return CheckResult.fromBool(value instanceof BooleanData);
            }
            case FLOAT: {
                return CheckResult.fromBool(value instanceof FloatData);
            }
            case HTML: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.HTML);
            }
            case INT: {
                return CheckResult.fromBool(value instanceof IntegerData);
            }
            case JS: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.JS);
            }
            case LIST: {
                return CheckResult.fromBool(value instanceof SoyList);
            }
            case MAP: {
                return CheckResult.fromBool(value instanceof SoyMap);
            }
            case LEGACY_OBJECT_MAP: {
                return CheckResult.fromBool(value instanceof SoyLegacyObjectMap);
            }
            case NULL: {
                return CheckResult.fromBool(value == NullData.INSTANCE || value == UndefinedData.INSTANCE);
            }
            case MESSAGE: {
                return CheckResult.fromBool(value instanceof SoyProtoValue);
            }
            case PROTO: {
                return CheckResult.fromBool(value instanceof SoyProtoValue && ((SoyProtoValue)value).getProto().getDescriptorForType() == ((SoyProtoType)type).getDescriptor());
            }
            case PROTO_ENUM: {
                return CheckResult.fromBool(value instanceof IntegerData);
            }
            case RECORD: {
                return CheckResult.fromBool(value instanceof SoyRecord);
            }
            case STRING: {
                if (Flags.stringIsNotSanitizedContent()) {
                    return CheckResult.fromBool(value instanceof SoyString);
                }
                if (value instanceof SoyString && value instanceof SanitizedContent && ((SanitizedContent)value).getContentKind() != SanitizedContent.ContentKind.TEXT && logger.isLoggable(Level.WARNING)) {
                    return CheckResult.passWithWarning(() -> logger.log(Level.WARNING, String.format("Passing in sanitized content into a template that accepts only string is forbidden. Please modify the template at %s to take in %s instead of just %s.", new Object[]{location != null ? location.toString() : "unknown", ((SanitizedContent)value).getContentKind(), type.toString()}), new Exception()));
                }
                return CheckResult.fromBool(value instanceof SoyString || value instanceof SanitizedContent);
            }
            case NAMED_TEMPLATE: {
                throw new AssertionError((Object)"Named template types should be resolved in the compiler.");
            }
            case TEMPLATE: {
                return CheckResult.fromBool(value instanceof TofuTemplateValue);
            }
            case TRUSTED_RESOURCE_URI: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI);
            }
            case UNION: {
                CheckResult unionResult = FAIL;
                for (SoyType memberType : ((UnionType)type).getMembers()) {
                    unionResult = unionResult.or(TofuTypeChecks.doIsInstance(memberType, value, location));
                }
                return unionResult;
            }
            case URI: {
                return TofuTypeChecks.isSanitizedofKind(value, SanitizedContent.ContentKind.URI);
            }
            case VE: {
                return CheckResult.fromBool(value == EvalVisitor.UNDEFINED_VE);
            }
            case VE_DATA: {
                return CheckResult.fromBool(value == EvalVisitor.UNDEFINED_VE_DATA);
            }
        }
        throw new AssertionError((Object)("invalid type: " + type));
    }

    private static CheckResult isSanitizedofKind(SoyValue value, SanitizedContent.ContentKind kind) {
        return CheckResult.fromBool(value instanceof SanitizedContent && ((SanitizedContent)value).getContentKind() == kind);
    }

    private static final class CheckResult {
        final boolean result;
        final Optional<Runnable> onPass;

        static final CheckResult fromBool(boolean result) {
            return result ? PASS : FAIL;
        }

        static final CheckResult passWithWarning(Runnable onPass) {
            return new CheckResult(true, Optional.of(onPass));
        }

        CheckResult(boolean result, Optional<Runnable> onPass) {
            this.result = result;
            this.onPass = (Optional)Preconditions.checkNotNull(onPass);
            if (onPass.isPresent() && !result) {
                throw new IllegalArgumentException("onPass values are only valid for successful results");
            }
        }

        CheckResult or(CheckResult other) {
            if (!this.result) {
                return other;
            }
            if (!other.result) {
                return this;
            }
            if (!this.onPass.isPresent()) {
                return this;
            }
            if (!other.onPass.isPresent()) {
                return other;
            }
            return CheckResult.passWithWarning(() -> {
                this.onPass.get().run();
                other.onPass.get().run();
            });
        }
    }
}

