/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.opti;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.plugin.internal.JavaPluginExecContext;
import com.google.template.soy.shared.restricted.SoyFunctions;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.sharedpasses.render.Environment;
import com.google.template.soy.sharedpasses.render.EvalVisitor;
import com.google.template.soy.sharedpasses.render.RenderException;
import java.util.List;

final class PreevalVisitor
extends EvalVisitor {
    PreevalVisitor(Environment env) {
        super(env, null, null, null, false, (ImmutableMap<String, Supplier<Object>>)ImmutableMap.of(), EvalVisitor.UndefinedDataHandlingMode.NORMAL);
    }

    @Override
    protected SoyValue visitVarRefNode(VarRefNode node) {
        if (node.isInjected()) {
            throw RenderException.create("Cannot preevaluate reference to ijData.");
        }
        SoyValue value = super.visitVarRefNode(node);
        if (value instanceof UndefinedData) {
            throw RenderException.create("Encountered undefined reference during preevaluation.");
        }
        return value;
    }

    @Override
    protected SoyValue computeFunctionHelper(SoyJavaFunction fn, List<SoyValue> args, FunctionNode fnNode) {
        Preconditions.checkArgument((fnNode.getSoyFunction() == fn ? 1 : 0) != 0);
        PreevalVisitor.checkPure(fn);
        return super.computeFunctionHelper(fn, args, fnNode);
    }

    @Override
    protected SoyValue computeFunctionHelper(List<SoyValue> args, JavaPluginExecContext fnNode) {
        PreevalVisitor.checkPure(fnNode.getSourceFunction());
        return super.computeFunctionHelper(args, fnNode);
    }

    private static void checkPure(Object fn) {
        if (!SoyFunctions.isPure(fn)) {
            throw RenderException.create("Cannot preevaluate impure function.");
        }
    }

    @Override
    protected SoyValue visitProtoInitNode(ProtoInitNode node) {
        throw RenderException.create("Cannot preevaluate proto initializers.");
    }
}

