/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;

public final class TagWhitelist {
    private final ImmutableSet<String> safeTagNames;
    private static final Pattern VALID_TAG_NAME = Pattern.compile("^[a-z][a-z0-9]*(?:-[a-z][a-z0-9]*)*\\z");
    public static final TagWhitelist FORMATTING = new TagWhitelist("b", "br", "em", "i", "s", "strong", "sub", "sup", "u");

    TagWhitelist(Collection<String> tagNames) {
        this.safeTagNames = ImmutableSet.copyOf(tagNames);
        TagWhitelist.requireLowerCaseTagNames(this.safeTagNames);
    }

    TagWhitelist(String ... tagNames) {
        this(Arrays.asList(tagNames));
    }

    public TagWhitelist withOptionalSafeTags(Collection<? extends OptionalSafeTag> optionalSafeTags) {
        if (optionalSafeTags.isEmpty()) {
            return this;
        }
        ImmutableSet optionalSafeTagNames = (ImmutableSet)optionalSafeTags.stream().map(OptionalSafeTag::getTagName).collect(ImmutableSet.toImmutableSet());
        return new TagWhitelist((Collection<String>)Sets.union(this.safeTagNames, (Set)optionalSafeTagNames));
    }

    public boolean isSafeTag(String tagName) {
        return this.safeTagNames.contains((Object)tagName);
    }

    public Set<String> asSet() {
        return this.safeTagNames;
    }

    private static void requireLowerCaseTagNames(Iterable<String> strs) {
        for (String str : strs) {
            Preconditions.checkArgument((str.equals(Ascii.toLowerCase((String)str)) && VALID_TAG_NAME.matcher(str).matches() ? 1 : 0) != 0, (Object)str);
        }
    }

    public static enum OptionalSafeTag {
        HR("hr"),
        LI("li"),
        OL("ol"),
        SPAN("span"),
        UL("ul");

        private final String tagName;
        private static final ImmutableMap<String, OptionalSafeTag> OPTIONAL_SAFE_TAGS_BY_TAG_NAME;

        private OptionalSafeTag(String tagName) {
            this.tagName = tagName;
        }

        public String getTagName() {
            return this.tagName;
        }

        public static OptionalSafeTag fromTagName(String tagName) {
            OptionalSafeTag tag = (OptionalSafeTag)((Object)OPTIONAL_SAFE_TAGS_BY_TAG_NAME.get((Object)tagName));
            if (tag == null) {
                throw new IllegalArgumentException(String.format("%s is not a valid optional safe tag.", tagName));
            }
            return tag;
        }

        static {
            OPTIONAL_SAFE_TAGS_BY_TAG_NAME = Maps.uniqueIndex(EnumSet.allOf(OptionalSafeTag.class), OptionalSafeTag::getTagName);
        }
    }
}

