/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.shared.restricted.SoyMethod;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.ErrorType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.TemplateBindingUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public enum BuiltinMethod implements SoyMethod
{
    GET_EXTENSION("getExtension", 1){

        @Override
        public boolean appliesToBase(SoyType baseType) {
            Preconditions.checkArgument((!SoyTypes.isNullable(baseType) ? 1 : 0) != 0);
            return baseType.getKind() == SoyType.Kind.PROTO;
        }

        @Override
        public SoyType getReturnType(String methodName, SoyType baseType, List<ExprNode> params, SoyTypeRegistry soyTypeRegistry, ErrorReporter errorReporter) {
            String fieldName;
            Preconditions.checkArgument((!SoyTypes.isNullable(baseType) ? 1 : 0) != 0);
            Preconditions.checkArgument((params.size() == 1 ? 1 : 0) != 0);
            SoyProtoType protoType = (SoyProtoType)baseType;
            ExprNode param = params.get(0);
            if (param.getKind() != ExprNode.Kind.GLOBAL_NODE) {
                errorReporter.report(param.getSourceLocation(), GET_EXTENSION_GLOBAL_REQUIRED, param.getType().toString());
                return ErrorType.getInstance();
            }
            GlobalNode parameter = (GlobalNode)param;
            ImmutableSet<String> fields = protoType.getExtensionFieldNames();
            if (!fields.contains((Object)(fieldName = parameter.getName()))) {
                String extraErrorMessage = SoyErrors.getDidYouMeanMessageForProtoFields(fields, protoType.getDescriptor(), fieldName);
                errorReporter.report(parameter.getSourceLocation(), PROTO_EXTENSION_DOES_NOT_EXIST, fieldName, protoType.getDescriptor().getFullName(), extraErrorMessage);
                return ErrorType.getInstance();
            }
            return protoType.getFieldType(fieldName);
        }
    }
    ,
    HAS_PROTO_FIELD("has[X]", 0){

        @Override
        public boolean appliesToBase(SoyType baseType) {
            Preconditions.checkArgument((!SoyTypes.isNullable(baseType) ? 1 : 0) != 0);
            return baseType.getKind() == SoyType.Kind.PROTO;
        }

        @Override
        public boolean appliesTo(String methodName, SoyType baseType) {
            if (!this.appliesToBase(baseType)) {
                return false;
            }
            if (!this.matchesName(methodName)) {
                return false;
            }
            SoyProtoType protoType = (SoyProtoType)baseType;
            String fieldName = BuiltinMethod.methodToFieldName(methodName);
            if (!protoType.getFieldNames().contains((Object)fieldName)) {
                return false;
            }
            return this.acceptFieldDescriptor(protoType.getFieldDescriptor(fieldName));
        }

        private boolean acceptFieldDescriptor(Descriptors.FieldDescriptor fd) {
            if (fd.isExtension() || fd.isRepeated() || fd.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                return false;
            }
            return fd.getFile().getSyntax() != Descriptors.FileDescriptor.Syntax.PROTO3;
        }

        @Override
        public SoyType getReturnType(String methodName, SoyType baseType, List<ExprNode> params, SoyTypeRegistry soyTypeRegistry, ErrorReporter errorReporter) {
            return BoolType.getInstance();
        }

        boolean matchesName(String methodName) {
            if (methodName.length() <= 3) {
                return false;
            }
            if (!methodName.startsWith("has")) {
                return false;
            }
            char firstChar = methodName.charAt(3);
            return firstChar >= 'A' && firstChar <= 'Z';
        }

        @Override
        ImmutableCollection<String> expandMethodNames(SoyType baseType, List<SoyType> argTypes) {
            if (baseType.getKind() != SoyType.Kind.PROTO) {
                return ImmutableList.of();
            }
            SoyProtoType protoType = (SoyProtoType)baseType;
            return (ImmutableCollection)protoType.getFieldNames().stream().filter(name -> this.acceptFieldDescriptor(protoType.getFieldDescriptor((String)name))).map(x$0 -> BuiltinMethod.fieldToHasMethodName(x$0)).collect(ImmutableSet.toImmutableSet());
        }
    }
    ,
    BIND("bind", 1){

        @Override
        public boolean appliesToBase(SoyType baseType) {
            Preconditions.checkArgument((!SoyTypes.isNullable(baseType) ? 1 : 0) != 0);
            return SoyTypes.isKindOrUnionOfKinds(baseType, (Set<SoyType.Kind>)ImmutableSet.of((Object)((Object)SoyType.Kind.TEMPLATE), (Object)((Object)SoyType.Kind.NAMED_TEMPLATE)));
        }

        @Override
        public SoyType getReturnType(String methodName, SoyType baseType, List<ExprNode> params, SoyTypeRegistry soyTypeRegistry, ErrorReporter errorReporter) {
            Preconditions.checkArgument((!SoyTypes.isNullable(baseType) ? 1 : 0) != 0);
            Preconditions.checkArgument((params.size() == 1 ? 1 : 0) != 0);
            ExprNode param = params.get(0);
            if (param.getKind() != ExprNode.Kind.RECORD_LITERAL_NODE) {
                errorReporter.report(param.getSourceLocation(), BIND_PARAMETER_MUST_BE_RECORD_LITERAL, new Object[0]);
                return ErrorType.getInstance();
            }
            return TemplateBindingUtil.bindParameters(baseType, (RecordType)param.getType(), soyTypeRegistry, errorReporter, param.getSourceLocation());
        }
    };

    private static final SoyErrorKind GET_EXTENSION_GLOBAL_REQUIRED;
    private static final SoyErrorKind PROTO_EXTENSION_DOES_NOT_EXIST;
    private static final SoyErrorKind BIND_PARAMETER_MUST_BE_RECORD_LITERAL;
    public static final SoyMethod.Registry REGISTRY;
    private final String name;
    private final int argCount;

    public static String getProtoFieldNameFromMethodCall(MethodCallNode node) {
        return BuiltinMethod.methodToFieldName(node.getMethodName().identifier());
    }

    public static String getProtoExtensionIdFromMethodCall(MethodCallNode node) {
        ExprNode arg = node.getChild(1);
        if (arg instanceof StringNode) {
            return ((StringNode)arg).getValue();
        }
        if (arg instanceof GlobalNode) {
            return ((GlobalNode)arg).getName();
        }
        throw new ClassCastException(arg.getClass().getName());
    }

    private static String methodToFieldName(String methodName) {
        Preconditions.checkArgument((methodName.length() >= 4 && (methodName.startsWith("get") || methodName.startsWith("has")) ? 1 : 0) != 0);
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, methodName.substring(3));
    }

    private static String fieldToHasMethodName(String fieldName) {
        return "has" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
    }

    private BuiltinMethod(String name, int argCount) {
        this.name = name;
        this.argCount = argCount;
    }

    public boolean appliesTo(String methodName, SoyType baseType) {
        return methodName.equals(this.name) && this.appliesToBase(baseType);
    }

    protected abstract boolean appliesToBase(SoyType var1);

    protected abstract SoyType getReturnType(String var1, SoyType var2, List<ExprNode> var3, SoyTypeRegistry var4, ErrorReporter var5);

    public final SoyType getReturnType(MethodCallNode node, SoyTypeRegistry soyTypeRegistry, ErrorReporter errorReporter) {
        String methodName = node.getMethodName().identifier();
        return this.getReturnType(methodName, node.getBaseType(true), node.getParams(), soyTypeRegistry, errorReporter);
    }

    @Override
    public int getNumArgs() {
        return this.argCount;
    }

    @Override
    public boolean appliesToArgs(List<SoyType> argTypes) {
        return argTypes.size() == this.getNumArgs();
    }

    ImmutableCollection<String> expandMethodNames(SoyType baseType, List<SoyType> argTypes) {
        return ImmutableList.of((Object)this.name);
    }

    public List<String> getProtoDependencyTypes(MethodCallNode methodNode) {
        switch (this) {
            case GET_EXTENSION: {
                return ImmutableList.of((Object)ProtoUtils.getQualifiedOuterClassname((Descriptors.GenericDescriptor)((SoyProtoType)SoyTypes.removeNull(methodNode.getBaseExprChild().getType())).getFieldDescriptor(BuiltinMethod.getProtoExtensionIdFromMethodCall(methodNode))));
            }
            case HAS_PROTO_FIELD: {
                return ImmutableList.of();
            }
            case BIND: {
                return ImmutableList.of();
            }
        }
        throw new AssertionError(this);
    }

    static {
        GET_EXTENSION_GLOBAL_REQUIRED = SoyErrorKind.of("The parameter of method ''getExtension'' must be a dotted identifier. Found ''{0}''", new SoyErrorKind.StyleAllowance[0]);
        PROTO_EXTENSION_DOES_NOT_EXIST = SoyErrorKind.of("Proto extension field ''{0}'' does not exist on the proto ''{1}''.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
        BIND_PARAMETER_MUST_BE_RECORD_LITERAL = SoyErrorKind.of("Parameter to bind() must be a record literal.", new SoyErrorKind.StyleAllowance[0]);
        REGISTRY = new SoyMethod.Registry(){

            @Override
            public ImmutableList<? extends SoyMethod> matchForNameAndBase(String methodName, SoyType baseType) {
                return (ImmutableList)Arrays.stream(BuiltinMethod.values()).filter(m -> m.appliesTo(methodName, baseType)).collect(ImmutableList.toImmutableList());
            }

            @Override
            public ImmutableMultimap<SoyMethod, String> matchForBaseAndArgs(SoyType baseType, List<SoyType> argTypes) {
                return (ImmutableMultimap)Arrays.stream(BuiltinMethod.values()).filter(m -> m.appliesToBase(baseType) && m.appliesToArgs(argTypes)).collect(ImmutableListMultimap.flatteningToImmutableListMultimap(m -> m, m -> m.expandMethodNames(baseType, argTypes).stream()));
            }
        };
    }
}

