/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.shared.restricted.SoyFunction;
import java.util.Set;
import javax.annotation.Nullable;

public enum BuiltinFunction implements SoyFunction
{
    IS_FIRST("isFirst"),
    IS_LAST("isLast"),
    INDEX("index"),
    CHECK_NOT_NULL("checkNotNull"),
    CSS("css"),
    XID("xid"),
    SOY_SERVER_KEY("$soyServerKey"),
    V1_EXPRESSION("v1Expression"),
    UNKNOWN_JS_GLOBAL("unknownJsGlobal"),
    REMAINDER("remainder"),
    MSG_WITH_ID("msgWithId"),
    VE_DATA("ve_data"),
    LEGACY_DYNAMIC_TAG("legacyDynamicTag"),
    IS_PRIMARY_MSG_IN_USE("$$isPrimaryMsgInUse"),
    TO_FLOAT("$$toFloat"),
    DEBUG_SOY_TEMPLATE_INFO("$$debugSoyTemplateInfo");

    private static final ImmutableMap<String, BuiltinFunction> NONPLUGIN_FUNCTIONS_BY_NAME;
    private final String functionName;

    public static ImmutableSet<String> names() {
        return NONPLUGIN_FUNCTIONS_BY_NAME.keySet();
    }

    @Nullable
    public static BuiltinFunction forFunctionName(String functionName) {
        return (BuiltinFunction)NONPLUGIN_FUNCTIONS_BY_NAME.get((Object)functionName);
    }

    private BuiltinFunction(String name) {
        this.functionName = name;
    }

    @Override
    public String getName() {
        return this.functionName;
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        switch (this) {
            case CSS: 
            case VE_DATA: {
                return ImmutableSet.of((Object)1, (Object)2);
            }
            case IS_PRIMARY_MSG_IN_USE: {
                return ImmutableSet.of((Object)3);
            }
            case DEBUG_SOY_TEMPLATE_INFO: {
                return ImmutableSet.of((Object)0);
            }
            case SOY_SERVER_KEY: 
            case IS_FIRST: 
            case IS_LAST: 
            case INDEX: 
            case CHECK_NOT_NULL: 
            case XID: 
            case UNKNOWN_JS_GLOBAL: 
            case LEGACY_DYNAMIC_TAG: 
            case V1_EXPRESSION: 
            case REMAINDER: 
            case MSG_WITH_ID: 
            case TO_FLOAT: {
                return ImmutableSet.of((Object)1);
            }
        }
        throw new AssertionError(this);
    }

    @Override
    public boolean isPure() {
        switch (this) {
            case VE_DATA: 
            case CHECK_NOT_NULL: 
            case MSG_WITH_ID: 
            case TO_FLOAT: {
                return true;
            }
            case CSS: 
            case IS_PRIMARY_MSG_IN_USE: 
            case DEBUG_SOY_TEMPLATE_INFO: 
            case SOY_SERVER_KEY: 
            case IS_FIRST: 
            case IS_LAST: 
            case INDEX: 
            case XID: 
            case UNKNOWN_JS_GLOBAL: 
            case LEGACY_DYNAMIC_TAG: 
            case V1_EXPRESSION: 
            case REMAINDER: {
                return false;
            }
        }
        throw new AssertionError(this);
    }

    static {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (BuiltinFunction nonpluginFn : BuiltinFunction.values()) {
            mapBuilder.put((Object)nonpluginFn.functionName, (Object)nonpluginFn);
        }
        NONPLUGIN_FUNCTIONS_BY_NAME = mapBuilder.build();
    }
}

