/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.template.soy.SoyUtils;
import com.google.template.soy.base.internal.TriState;
import com.google.template.soy.data.internalutils.InternalValueUtils;
import com.google.template.soy.data.restricted.PrimitiveData;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public final class SoyGeneralOptions
implements Cloneable {
    private TriState allowExternalCalls = TriState.UNSET;
    private ImmutableMap<String, PrimitiveData> compileTimeGlobals;
    private ImmutableSet<String> experimentalFeatures = ImmutableSet.of();

    public SoyGeneralOptions() {
    }

    private SoyGeneralOptions(SoyGeneralOptions orig) {
        this.allowExternalCalls = orig.allowExternalCalls;
        this.compileTimeGlobals = orig.compileTimeGlobals;
        this.experimentalFeatures = ImmutableSet.copyOf(orig.experimentalFeatures);
    }

    public SoyGeneralOptions setExperimentalFeatures(Iterable<String> experimentalFeatures) {
        this.experimentalFeatures = ImmutableSet.copyOf(experimentalFeatures);
        return this;
    }

    public ImmutableSet<String> getExperimentalFeatures() {
        return this.experimentalFeatures;
    }

    public SoyGeneralOptions setAllowExternalCalls(boolean allowExternalCalls) {
        this.allowExternalCalls = TriState.from(allowExternalCalls);
        return this;
    }

    public TriState allowExternalCalls() {
        return this.allowExternalCalls;
    }

    public SoyGeneralOptions setCompileTimeGlobals(Map<String, ?> compileTimeGlobalsMap) {
        this.setCompileTimeGlobalsInternal(InternalValueUtils.convertCompileTimeGlobalsMap(compileTimeGlobalsMap));
        return this;
    }

    private void setCompileTimeGlobalsInternal(ImmutableMap<String, PrimitiveData> compileTimeGlobalsMap) {
        Preconditions.checkState((this.compileTimeGlobals == null ? 1 : 0) != 0, (Object)"Compile-time globals already set.");
        this.compileTimeGlobals = compileTimeGlobalsMap;
    }

    public SoyGeneralOptions setCompileTimeGlobals(File compileTimeGlobalsFile) throws IOException {
        this.setCompileTimeGlobalsInternal(SoyUtils.parseCompileTimeGlobals(Files.asCharSource((File)compileTimeGlobalsFile, (Charset)StandardCharsets.UTF_8)));
        return this;
    }

    public SoyGeneralOptions setCompileTimeGlobals(URL compileTimeGlobalsResource) throws IOException {
        this.setCompileTimeGlobalsInternal(SoyUtils.parseCompileTimeGlobals(Resources.asCharSource((URL)compileTimeGlobalsResource, (Charset)StandardCharsets.UTF_8)));
        return this;
    }

    public ImmutableMap<String, PrimitiveData> getCompileTimeGlobals() {
        return this.compileTimeGlobals == null ? ImmutableMap.of() : this.compileTimeGlobals;
    }

    public final SoyGeneralOptions clone() {
        return new SoyGeneralOptions(this);
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("allowExternalCalls", (Object)this.allowExternalCalls).add("compileTimeGlobals", this.compileTimeGlobals).add("experimentalFeatures", this.experimentalFeatures).toString();
    }
}

