/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.plugin.java.internal;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.plugin.java.internal.ValidatorContext;
import com.google.template.soy.plugin.java.internal.ValidatorErrorReporter;
import com.google.template.soy.plugin.java.internal.ValidatorFactory;
import com.google.template.soy.plugin.java.internal.ValidatorValue;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.plugin.java.restricted.MethodSignature;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.LegacyObjectMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JavaPluginValidator {
    private final SoyTypeRegistry typeRegistry;
    private final ErrorReporter baseReporter;

    public JavaPluginValidator(ErrorReporter reporter, SoyTypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
        this.baseReporter = reporter;
    }

    public void validate(String fnName, SoyJavaSourceFunction fn, List<SoyType> expectedParams, SoyType expectedReturn, SourceLocation sourceLocation, boolean includeTriggeredInTemplateMsg) {
        ValidatorErrorReporter reporter = new ValidatorErrorReporter(this.baseReporter, fnName, fn.getClass(), sourceLocation, includeTriggeredInTemplateMsg);
        ValidatorFactory factory = new ValidatorFactory(reporter);
        ValidatorContext context = new ValidatorContext(reporter);
        JavaValue result = null;
        try {
            result = fn.applyForJavaSource(factory, (List)expectedParams.stream().map(t -> ValidatorValue.forSoyType(t, reporter)).collect(ImmutableList.toImmutableList()), context);
            if (result == null) {
                reporter.nullReturn();
            }
        }
        catch (Throwable t2) {
            BaseUtils.trimStackTraceTo(t2, this.getClass());
            reporter.unexpectedError(t2);
        }
        if (result != null) {
            this.validateReturnValue((ValidatorValue)result, expectedReturn, reporter);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void validateReturnValue(ValidatorValue pluginReturnValue, SoyType expectedType, ValidatorErrorReporter reporter) {
        void var4_15;
        void var4_8;
        if (pluginReturnValue.isError()) {
            return;
        }
        Object var4_4 = null;
        switch (pluginReturnValue.valueType().type()) {
            case CONSTANT_NULL: {
                NullType nullType = NullType.getInstance();
                break;
            }
            case SOY_TYPE: {
                SoyType soyType = pluginReturnValue.valueType().soyType();
                break;
            }
            case CLAZZ: {
                Object var4_7 = null;
                break;
            }
        }
        if (var4_8 == null) {
            MethodSignature method = pluginReturnValue.methodInfo();
            Class<?> actualClass = method != null ? method.returnType() : pluginReturnValue.valueType().clazz();
            if (List.class.isAssignableFrom(actualClass)) {
                if (expectedType instanceof ListType) {
                    SoyType soyType = expectedType;
                } else {
                    if (expectedType.getKind() != SoyType.Kind.UNKNOWN && expectedType.getKind() != SoyType.Kind.ANY) {
                        reporter.invalidReturnType(actualClass, expectedType, method);
                        return;
                    }
                    ListType listType = ListType.of(UnknownType.getInstance());
                }
            } else if (Map.class.isAssignableFrom(actualClass)) {
                if (!(expectedType instanceof MapType || expectedType instanceof RecordType || expectedType instanceof LegacyObjectMapType)) {
                    reporter.invalidReturnType(actualClass, expectedType, method);
                    return;
                }
                SoyType soyType = expectedType;
            } else if (SoyValue.class.isAssignableFrom(actualClass)) {
                SoyType soyType = expectedType;
            } else if (Message.class.isAssignableFrom(actualClass)) {
                Optional<SoyType> returnType = this.soyTypeForProtoOrEnum(actualClass, expectedType, method, reporter);
                if (!returnType.isPresent()) {
                    return;
                }
                SoyType soyType = returnType.get();
            } else if (actualClass.isEnum() && ProtocolMessageEnum.class.isAssignableFrom(actualClass)) {
                Optional<SoyType> returnType = this.soyTypeForProtoOrEnum(actualClass, expectedType, method, reporter);
                if (!returnType.isPresent()) {
                    return;
                }
                if (!expectedType.isAssignableFrom(returnType.get())) {
                    reporter.incompatibleReturnType(returnType.get(), expectedType, method);
                    return;
                }
                IntType intType = IntType.getInstance();
            } else {
                reporter.invalidReturnType(actualClass, expectedType, method);
                return;
            }
        }
        if (var4_15.getKind() == SoyType.Kind.INT && this.isOrContains(expectedType, SoyType.Kind.PROTO_ENUM)) {
            return;
        }
        boolean bl = false;
        boolean isPossibleProtoEnum = bl;
        if (isPossibleProtoEnum) return;
        if (expectedType.isAssignableFrom((SoyType)var4_15)) return;
        reporter.incompatibleReturnType((SoyType)var4_15, expectedType, pluginReturnValue.methodInfo());
    }

    private Optional<SoyType> soyTypeForProtoOrEnum(Class<?> actualType, SoyType expectedType, MethodSignature method, ValidatorErrorReporter reporter) {
        if (actualType == Message.class) {
            reporter.invalidReturnType(Message.class, expectedType, method);
            return Optional.empty();
        }
        Optional<String> fullName = ValidatorFactory.nameFromDescriptor(actualType);
        if (!fullName.isPresent()) {
            reporter.incompatibleReturnType(actualType, expectedType, method);
            return Optional.empty();
        }
        SoyType returnType = this.typeRegistry.getProtoRegistry().getProtoType(fullName.get());
        if (returnType == null) {
            reporter.incompatibleReturnType(actualType, expectedType, method);
            return Optional.empty();
        }
        return Optional.of(returnType);
    }

    private boolean isOrContains(SoyType type, SoyType.Kind kind) {
        if (type.getKind() == kind) {
            return true;
        }
        if (type.getKind() == SoyType.Kind.UNION) {
            for (SoyType member : ((UnionType)type).getMembers()) {
                if (member.getKind() != kind) continue;
                return true;
            }
        }
        return false;
    }
}

