/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes.htmlmatcher;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherAccumulatorNode;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherBlockNode;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherConditionNode;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherGraph;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherGraphNode;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherTagNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TagName;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public final class HtmlTagMatchingPass {
    private static final SoyErrorKind INVALID_CLOSE_TAG = SoyErrorKind.of("''{0}'' tag is a void element and must not specify a close tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_SELF_CLOSING_TAG = SoyErrorKind.of("''{0}'' tag is not allowed to be self-closing.", new SoyErrorKind.StyleAllowance[0]);
    private static final String UNEXPECTED_CLOSE_TAG = "Unexpected HTML close tag.";
    private static final String UNEXPECTED_CLOSE_TAG_KNOWN = "Unexpected HTML close tag. Expected to match the ''<{0}>'' at {1}.";
    private static final String BLOCK_QUALIFIER = " Tags within a %s must be internally balanced.";
    private static final String UNEXPECTED_OPEN_TAG_ALWAYS = "This HTML open tag is never matched with a close tag.";
    private static final String UNEXPECTED_OPEN_TAG_SOMETIMES = "This HTML open tag does not consistently match with a close tag.";
    private static final Optional<HtmlTagNode> INVALID_NODE = Optional.empty();
    private final ErrorReporter errorReporter;
    private final IdGenerator idGenerator;
    private final boolean inCondition;
    private final int foreignContentTagDepth;
    @Nullable
    private final String parentBlockType;
    private final SetMultimap<HtmlTagNode, Optional<HtmlTagNode>> annotationMap = LinkedHashMultimap.create();
    private final ExprEquivalence exprEquivalence = new ExprEquivalence();

    public HtmlTagMatchingPass(ErrorReporter errorReporter, IdGenerator idGenerator, boolean inCondition, int foreignContentTagDepth, String parentBlockType) {
        this.foreignContentTagDepth = foreignContentTagDepth;
        this.parentBlockType = parentBlockType;
        this.errorReporter = errorReporter;
        this.idGenerator = idGenerator;
        this.inCondition = inCondition;
    }

    private SoyErrorKind makeSoyErrorKind(String soyError) {
        return SoyErrorKind.of(soyError + (this.parentBlockType != null ? String.format(BLOCK_QUALIFIER, this.parentBlockType) : ""), new SoyErrorKind.StyleAllowance[0]);
    }

    public void run(HtmlMatcherGraph htmlMatcherGraph) {
        if (!htmlMatcherGraph.getRootNode().isPresent()) {
            return;
        }
        this.visit(htmlMatcherGraph.getRootNode().get());
        for (HtmlTagNode tag : this.annotationMap.keySet()) {
            HtmlOpenTagNode openTag;
            if (!(tag instanceof HtmlOpenTagNode) || !this.annotationMap.containsEntry((Object)(openTag = (HtmlOpenTagNode)tag), INVALID_NODE)) continue;
            if (this.annotationMap.get((Object)openTag).size() == 1) {
                if (tag.getTagName().isExcludedOptionalTag()) continue;
                this.errorReporter.report(openTag.getSourceLocation(), this.makeSoyErrorKind(UNEXPECTED_OPEN_TAG_ALWAYS), new Object[0]);
                continue;
            }
            this.errorReporter.report(openTag.getSourceLocation(), this.makeSoyErrorKind(UNEXPECTED_OPEN_TAG_SOMETIMES), new Object[0]);
        }
        if (this.errorReporter.hasErrors() && this.inCondition) {
            return;
        }
        for (HtmlTagNode openTag : this.annotationMap.keySet()) {
            for (Optional closeTag : this.annotationMap.get((Object)openTag)) {
                if (!closeTag.isPresent()) continue;
                openTag.addTagPair((HtmlTagNode)closeTag.get());
                ((HtmlTagNode)closeTag.get()).addTagPair(openTag);
            }
        }
    }

    private void injectCloseTag(HtmlOpenTagNode optionalOpenTag, HtmlTagNode destinationTag, IdGenerator idGenerator) {
        SoyNode.StandaloneNode openTagCopy = optionalOpenTag.getTagName().getNode().copy(new CopyState());
        HtmlCloseTagNode syntheticClose = new HtmlCloseTagNode(idGenerator.genId(), openTagCopy, optionalOpenTag.getSourceLocation(), HtmlTagNode.TagExistence.SYNTHETIC);
        if (destinationTag == null) {
            int i = optionalOpenTag.getParent().numChildren();
            optionalOpenTag.getParent().addChild(i, syntheticClose);
        } else {
            ParentNode openTagParent = destinationTag.getParent();
            int i = openTagParent.getChildIndex(destinationTag);
            openTagParent.addChild(i, syntheticClose);
        }
        this.annotationMap.put((Object)optionalOpenTag, Optional.of(syntheticClose));
        this.annotationMap.put((Object)syntheticClose, Optional.of(optionalOpenTag));
    }

    private List<QueuedTask> visit(HtmlMatcherTagNode tagNode, Map<ExprEquivalence.Wrapper, Boolean> exprValueMap, HtmlStack stack) {
        HtmlTagNode tag = (HtmlTagNode)tagNode.getSoyNode().get();
        TagName openTagName = tag.getTagName();
        HtmlStack prev = stack;
        block0 : switch (tagNode.getTagKind()) {
            case VOID_TAG: {
                HtmlOpenTagNode voidTag = (HtmlOpenTagNode)tag;
                if (stack.foreignContentTagDepth != 0 || openTagName.isDefinitelyVoid() || !voidTag.isSelfClosing() || !openTagName.isStatic()) break;
                this.errorReporter.report(voidTag.getSourceLocation(), INVALID_SELF_CLOSING_TAG, openTagName.getStaticTagName());
                break;
            }
            case OPEN_TAG: {
                HtmlOpenTagNode optionalTag;
                HtmlOpenTagNode openTag = (HtmlOpenTagNode)tag;
                if (!prev.isEmpty() && (optionalTag = stack.tagNode).getTagName().isDefinitelyOptional() && TagName.checkOpenTagClosesOptional(openTag.getTagName(), optionalTag.getTagName())) {
                    this.injectCloseTag(optionalTag, openTag, this.idGenerator);
                    prev = prev.pop();
                }
                prev = prev.push(openTag, stack.foreignContentTagDepth + (openTag.getTagName().isForeignContent() ? 1 : 0));
                break;
            }
            case CLOSE_TAG: {
                HtmlCloseTagNode closeTag = (HtmlCloseTagNode)tag;
                if (closeTag.getTagName().isDefinitelyVoid()) {
                    this.errorReporter.report(closeTag.getTagName().getTagLocation(), INVALID_CLOSE_TAG, closeTag.getTagName().getStaticTagName());
                    break;
                }
                if (stack.isEmpty() && !closeTag.getTagName().isExcludedOptionalTag()) {
                    this.errorReporter.report(closeTag.getSourceLocation(), this.makeSoyErrorKind(UNEXPECTED_CLOSE_TAG), new Object[0]);
                    break;
                }
                prev = stack;
                while (!prev.isEmpty()) {
                    HtmlOpenTagNode nextOpenTag = prev.tagNode;
                    if (nextOpenTag.getTagName().equals(closeTag.getTagName())) {
                        this.annotationMap.put((Object)nextOpenTag, Optional.of(closeTag));
                        this.annotationMap.put((Object)closeTag, Optional.of(nextOpenTag));
                        prev = prev.pop();
                        break block0;
                    }
                    if (nextOpenTag.getTagName().isDefinitelyOptional() && TagName.checkCloseTagClosesOptional(closeTag.getTagName(), nextOpenTag.getTagName())) {
                        this.injectCloseTag(nextOpenTag, closeTag, this.idGenerator);
                        prev = prev.pop();
                        continue;
                    }
                    this.annotationMap.put((Object)nextOpenTag, INVALID_NODE);
                    if (!closeTag.getTagName().isExcludedOptionalTag()) {
                        this.errorReporter.report(closeTag.getSourceLocation(), this.makeSoyErrorKind(UNEXPECTED_CLOSE_TAG_KNOWN), nextOpenTag.getTagName(), nextOpenTag.getSourceLocation());
                    }
                    prev = prev.pop();
                }
                break;
            }
        }
        Optional<HtmlMatcherGraphNode> nextNode = tagNode.getNodeForEdgeKind(HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE);
        return ImmutableList.of((Object)this.visit(nextNode, exprValueMap, prev));
    }

    private List<QueuedTask> visit(HtmlMatcherBlockNode blockNode, Map<ExprEquivalence.Wrapper, Boolean> exprValueMap, HtmlStack stack) {
        if (blockNode.getGraph().getRootNode().isPresent()) {
            new HtmlTagMatchingPass(this.errorReporter, this.idGenerator, false, stack.foreignContentTagDepth, blockNode.getParentBlockType()).run(blockNode.getGraph());
        }
        Optional<HtmlMatcherGraphNode> nextNode = blockNode.getNodeForEdgeKind(HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE);
        return ImmutableList.of((Object)this.visit(nextNode, exprValueMap, stack));
    }

    private List<QueuedTask> visit(HtmlMatcherConditionNode condNode, Map<ExprEquivalence.Wrapper, Boolean> exprValueMap, HtmlStack stack) {
        ExprEquivalence.Wrapper condition = this.exprEquivalence.wrap(condNode.getExpression());
        Boolean originalState = exprValueMap.getOrDefault(condition, null);
        Optional<HtmlMatcherGraphNode> nextNode = condNode.getNodeForEdgeKind(HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE);
        Optional<HtmlMatcherGraphNode> nextAltNode = condNode.getNodeForEdgeKind(HtmlMatcherGraphNode.EdgeKind.FALSE_EDGE);
        ImmutableList.Builder tasks = ImmutableList.builder();
        if (!condNode.isInternallyBalanced(stack.foreignContentTagDepth, this.idGenerator) && nextNode.isPresent() && !Boolean.FALSE.equals(originalState)) {
            HashMap<ExprEquivalence.Wrapper, Boolean> lMap = new HashMap<ExprEquivalence.Wrapper, Boolean>(exprValueMap);
            lMap.put(condition, true);
            tasks.add((Object)this.visit(nextNode, lMap, stack));
        }
        if (nextAltNode.isPresent() && !Boolean.TRUE.equals(originalState)) {
            HashMap<ExprEquivalence.Wrapper, Boolean> rMap = new HashMap<ExprEquivalence.Wrapper, Boolean>(exprValueMap);
            rMap.put(condition, false);
            tasks.add((Object)this.visit(nextAltNode, rMap, stack));
        }
        return tasks.build();
    }

    private List<QueuedTask> visit(HtmlMatcherAccumulatorNode accNode, Map<ExprEquivalence.Wrapper, Boolean> exprValueMap, HtmlStack stack) {
        Optional<HtmlMatcherGraphNode> nextNode = accNode.getNodeForEdgeKind(HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE);
        return ImmutableList.of((Object)this.visit(nextNode, exprValueMap, stack));
    }

    public void visit(HtmlMatcherGraphNode node) {
        ArrayDeque<QueuedTask> stack = new ArrayDeque<QueuedTask>();
        stack.add(this.visit(Optional.of(node), new HashMap<ExprEquivalence.Wrapper, Boolean>(), new HtmlStack(null, this.foreignContentTagDepth, null)));
        while (!stack.isEmpty()) {
            QueuedTask task = (QueuedTask)stack.remove();
            List<QueuedTask> newTasks = task.run();
            stack.addAll(newTasks);
        }
    }

    private QueuedTask visit(Optional<HtmlMatcherGraphNode> maybeNode, Map<ExprEquivalence.Wrapper, Boolean> exprValueMap, HtmlStack stack) {
        if (!maybeNode.isPresent()) {
            return () -> {
                this.checkUnusedTags(stack);
                return ImmutableList.of();
            };
        }
        HtmlMatcherGraphNode node = maybeNode.get();
        if (node instanceof HtmlMatcherTagNode) {
            return () -> this.visit((HtmlMatcherTagNode)node, exprValueMap, stack);
        }
        if (node instanceof HtmlMatcherConditionNode) {
            return () -> this.visit((HtmlMatcherConditionNode)node, exprValueMap, stack);
        }
        if (node instanceof HtmlMatcherAccumulatorNode) {
            return () -> this.visit((HtmlMatcherAccumulatorNode)node, exprValueMap, stack);
        }
        if (node instanceof HtmlMatcherBlockNode) {
            return () -> this.visit((HtmlMatcherBlockNode)node, exprValueMap, stack);
        }
        throw new UnsupportedOperationException("No implementation for: " + node);
    }

    private void checkUnusedTags(HtmlStack stack) {
        while (!stack.isEmpty()) {
            if (stack.tagNode.getTagName().isDefinitelyOptional() && !this.inCondition) {
                this.injectCloseTag(stack.tagNode, null, this.idGenerator);
            } else {
                this.annotationMap.put((Object)stack.tagNode, INVALID_NODE);
            }
            stack = stack.pop();
        }
    }

    @FunctionalInterface
    static interface QueuedTask {
        public List<QueuedTask> run();
    }

    class HtmlStack {
        final HtmlOpenTagNode tagNode;
        final int foreignContentTagDepth;
        final HtmlStack prev;

        HtmlStack(HtmlOpenTagNode tagNode, int foreignContentTagDepth, HtmlStack prev) {
            this.tagNode = tagNode;
            this.foreignContentTagDepth = foreignContentTagDepth;
            this.prev = prev;
        }

        HtmlStack push(HtmlOpenTagNode tagNode, int foreignContentTagDepth) {
            return new HtmlStack(tagNode, foreignContentTagDepth, this);
        }

        HtmlStack pop() {
            return this.prev;
        }

        boolean isEmpty() {
            return this.tagNode == null;
        }

        public String toString() {
            if (this.prev == null) {
                return "[START]";
            }
            return this.prev + "->" + this.tagNode.getTagName();
        }
    }
}

