/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes.htmlmatcher;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherGraph;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherGraphNode;
import com.google.template.soy.passes.htmlmatcher.HtmlTagMatchingPass;
import com.google.template.soy.soytree.SoyNode;
import java.util.Optional;
import javax.annotation.Nullable;

public final class HtmlMatcherConditionNode
extends HtmlMatcherGraphNode {
    private final SoyNode soyNode;
    private HtmlMatcherGraphNode.EdgeKind activeEdge = HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE;
    private final ExprNode expression;
    private final HtmlMatcherGraph graph;
    @Nullable
    private HtmlMatcherGraphNode trueBranchNode = null;
    @Nullable
    private HtmlMatcherGraphNode falseBranchNode = null;
    private Optional<Boolean> isInternallyBalancedForForeignContent = Optional.empty();
    private Optional<Boolean> isInternallyBalanced = Optional.empty();

    public HtmlMatcherConditionNode(SoyNode soyNode, ExprNode expression, HtmlMatcherGraph graph) {
        this.soyNode = soyNode;
        this.expression = expression;
        this.graph = graph;
    }

    public HtmlMatcherConditionNode(SoyNode soyNode, ExprNode expression) {
        this.soyNode = soyNode;
        this.expression = expression;
        this.graph = null;
    }

    public ExprNode getExpression() {
        return this.expression;
    }

    public boolean isInternallyBalanced(int foreignContentTagDepth, IdGenerator idGenerator) {
        ErrorReporter errorReporter = ErrorReporter.createForTest();
        HtmlTagMatchingPass pass = new HtmlTagMatchingPass(errorReporter, idGenerator, true, foreignContentTagDepth, "condition");
        if (foreignContentTagDepth > 0) {
            if (!this.isInternallyBalancedForForeignContent.isPresent()) {
                pass.run(this.graph);
                this.isInternallyBalancedForForeignContent = Optional.of(errorReporter.getErrors().isEmpty());
            }
            return this.isInternallyBalancedForForeignContent.get();
        }
        if (!this.isInternallyBalanced.isPresent()) {
            pass.run(this.graph);
            this.isInternallyBalanced = Optional.of(errorReporter.getErrors().isEmpty());
        }
        return this.isInternallyBalanced.get();
    }

    @Override
    public Optional<SoyNode> getSoyNode() {
        return Optional.of(this.soyNode);
    }

    @Override
    public HtmlMatcherGraphNode.EdgeKind getActiveEdgeKind() {
        return this.activeEdge;
    }

    @Override
    public void setActiveEdgeKind(HtmlMatcherGraphNode.EdgeKind edgeKind) {
        this.activeEdge = edgeKind;
    }

    @Override
    public void linkEdgeToNode(HtmlMatcherGraphNode.EdgeKind edgeKind, HtmlMatcherGraphNode node) {
        Preconditions.checkState((!this.equals(node) ? 1 : 0) != 0, (Object)"Cannot link a node to itself.");
        switch (edgeKind) {
            case TRUE_EDGE: {
                this.trueBranchNode = node;
                break;
            }
            case FALSE_EDGE: {
                this.falseBranchNode = node;
            }
        }
    }

    @Override
    public Optional<HtmlMatcherGraphNode> getNodeForEdgeKind(HtmlMatcherGraphNode.EdgeKind edgeKind) {
        switch (edgeKind) {
            case TRUE_EDGE: {
                return Optional.ofNullable(this.trueBranchNode);
            }
            case FALSE_EDGE: {
                return Optional.ofNullable(this.falseBranchNode);
            }
        }
        return Optional.empty();
    }
}

