/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.AbstractNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.VeLogNode;

final class VeRewritePass
implements CompilerFilePass {
    VeRewritePass() {
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (AbstractNode node : SoyTreeUtils.getAllNodesOfType(file, VeLogNode.class)) {
            this.maybeRewriteVeLogNode((VeLogNode)node);
        }
        for (AbstractNode node : SoyTreeUtils.getAllFunctionInvocations(file, BuiltinFunction.VE_DATA)) {
            this.maybeRewriteVeDataNode((FunctionNode)node);
        }
    }

    private void maybeRewriteVeLogNode(VeLogNode node) {
        if (node.getVeDataExpression().getRoot().getKind() == ExprNode.Kind.GLOBAL_NODE) {
            GlobalNode veName = (GlobalNode)node.getVeDataExpression().getRoot();
            FunctionNode veData = new FunctionNode(Identifier.create(BuiltinFunction.VE_DATA.getName(), veName.getSourceLocation()), BuiltinFunction.VE_DATA, veName.getSourceLocation());
            veData.addChild(veName);
            node.getVeDataExpression().addChild(veData);
        }
    }

    private void maybeRewriteVeDataNode(FunctionNode node) {
        if (node.numChildren() < 1 || node.numChildren() > 2) {
            return;
        }
        if (node.getChild(0).getKind() == ExprNode.Kind.GLOBAL_NODE) {
            GlobalNode global = (GlobalNode)node.getChild(0);
            VeLiteralNode veNode = new VeLiteralNode(Identifier.create("ve", global.getSourceLocation()), Identifier.create(global.getName(), global.getSourceLocation()), global.getSourceLocation());
            node.replaceChild(0, (ExprNode)veNode);
        }
        if (node.numChildren() < 2) {
            node.addChild(new NullNode(node.getSourceLocation().getEndLocation()));
        }
    }
}

