/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplatesPerFile;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;

final class ValidateAliasesPass
implements CompilerFilePass {
    private static final SoyErrorKind ALIAS_CONFLICTS_WITH_GLOBAL = SoyErrorKind.of("Alias ''{0}'' conflicts with a global of the same name.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ALIAS_CONFLICTS_WITH_GLOBAL_PREFIX = SoyErrorKind.of("Alias ''{0}'' conflicts with namespace for global ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ALIAS_CONFLICTS_WITH_TYPE_NAME = SoyErrorKind.of("Alias ''{0}'' conflicts with a type of the same name.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ALIAS_CONFLICTS_WITH_TYPE_PREFIX = SoyErrorKind.of("Alias ''{0}'' conflicts with namespace for type ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ALIAS_CONFLICTS_WITH_VE = SoyErrorKind.of("Alias ''{0}'' conflicts with a VE of the same name.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ALIAS_CONFLICTS_WITH_AN_IMPORT_SYMBOL = SoyErrorKind.of("Alias ''{0}'' conflicts with an imported template symbol.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final SoyGeneralOptions options;
    private final ValidatedLoggingConfig loggingConfig;

    ValidateAliasesPass(ErrorReporter errorReporter, SoyGeneralOptions options, ValidatedLoggingConfig loggingConfig) {
        this.errorReporter = errorReporter;
        this.options = options;
        this.loggingConfig = loggingConfig;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        SoyTypeRegistry registry = file.getSoyTypeRegistry();
        for (AliasDeclaration alias : file.getAliasDeclarations()) {
            String conflictingNamespacedType;
            ImmutableMap<String, TemplatesPerFile.TemplateName> tmplImports;
            SoyType type;
            if (this.options.getCompileTimeGlobals().containsKey((Object)alias.alias().identifier())) {
                this.errorReporter.report(alias.alias().location(), ALIAS_CONFLICTS_WITH_GLOBAL, alias.alias());
            }
            if ((type = registry.getType(alias.alias().identifier())) != null && type.getKind() != SoyType.Kind.UNKNOWN && !alias.namespace().identifier().equals(ValidateAliasesPass.getFqProtoName(type))) {
                this.errorReporter.report(alias.alias().location(), ALIAS_CONFLICTS_WITH_TYPE_NAME, alias.alias());
            }
            if ((tmplImports = file.getTemplateRegistry().getSymbolsToTemplateNamesMap()).containsKey(alias.alias().identifier()) && !alias.namespace().identifier().equals(((TemplatesPerFile.TemplateName)tmplImports.get(alias.alias().identifier())).fullyQualifiedName())) {
                this.errorReporter.report(alias.alias().location(), ALIAS_CONFLICTS_WITH_AN_IMPORT_SYMBOL, alias.alias());
            }
            if ((conflictingNamespacedType = registry.findTypeWithMatchingNamespace(alias.alias().identifier())) != null) {
                this.errorReporter.report(alias.alias().location(), ALIAS_CONFLICTS_WITH_TYPE_PREFIX, alias.alias(), conflictingNamespacedType);
            }
            String prefix = alias.alias().identifier() + ".";
            for (String global : this.options.getCompileTimeGlobals().keySet()) {
                if (!global.startsWith(prefix)) continue;
                this.errorReporter.report(alias.alias().location(), ALIAS_CONFLICTS_WITH_GLOBAL_PREFIX, alias.alias(), global);
            }
            if (this.loggingConfig.getElement(alias.alias().identifier()) == null) continue;
            this.errorReporter.report(alias.alias().location(), ALIAS_CONFLICTS_WITH_VE, alias.alias());
        }
    }

    private static String getFqProtoName(SoyType type) {
        if (type instanceof SoyProtoType) {
            return ((SoyProtoType)type).getDescriptor().getFullName();
        }
        if (type instanceof SoyProtoEnumType) {
            return ((SoyProtoEnumType)type).getDescriptor().getFullName();
        }
        return null;
    }
}

