/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.soytree.ImportsContext;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.ErrorType;
import com.google.template.soy.types.LegacyObjectMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.MessageType;
import com.google.template.soy.types.NamedTemplateType;
import com.google.template.soy.types.PrimitiveType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypeVisitor;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.TemplateBindingUtil;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.UnknownType;
import com.google.template.soy.types.VeType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

final class UpgradeTemplateTypesPass
implements CompilerFileSetPass {
    private static final SoyErrorKind ONLY_BASIC_TEMPLATES_ALLOWED = SoyErrorKind.of("Only basic templates are allowed in expressions, but found template of kind: `{0}`.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ONLY_STRICT_HTML_TEMPLATES_ALLOWED = SoyErrorKind.of("Only strict HTML templates are allowed in expressions, but template `{0}` was not strict HTML.", new SoyErrorKind.StyleAllowance[0]);
    private final SoyTypeRegistry typeRegistry;
    private final ErrorReporter errorReporter;
    private final Set<String> invalidTemplateNames = new HashSet<String>();
    private final Set<String> reportedInvalidTemplateNames = new HashSet<String>();

    UpgradeTemplateTypesPass(SoyTypeRegistry typeRegistry, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        for (SoyFileNode file : sourceFiles) {
            ImportsContext.ImportsTemplateRegistry templateRegistry = file.getTemplateRegistry();
            block5: for (ExprNode exprNode : SoyTreeUtils.getAllNodesOfType(file, ExprNode.class)) {
                if (!SoyTypes.transitivelyContainsKind(exprNode.getType(), SoyType.Kind.NAMED_TEMPLATE)) continue;
                boolean isTemplateLiteral = exprNode.getKind() == ExprNode.Kind.TEMPLATE_LITERAL_NODE;
                boolean isSynthetic = isTemplateLiteral && ((TemplateLiteralNode)exprNode).isSynthetic() || exprNode.getKind() == ExprNode.Kind.EXPR_ROOT_NODE && ((ExprRootNode)exprNode).getRoot().getKind() == ExprNode.Kind.TEMPLATE_LITERAL_NODE && ((TemplateLiteralNode)((ExprRootNode)exprNode).getRoot()).isSynthetic();
                SoyType resolvedType = exprNode.getType().accept(new TemplateTypeUpgrader(exprNode.getSourceLocation(), templateRegistry, isTemplateLiteral, isSynthetic));
                switch (exprNode.getKind()) {
                    case TEMPLATE_LITERAL_NODE: {
                        ((TemplateLiteralNode)exprNode).setType(resolvedType);
                        continue block5;
                    }
                    case VAR_REF_NODE: {
                        ((VarRefNode)exprNode).setSubstituteType(resolvedType);
                        continue block5;
                    }
                }
                if (exprNode instanceof AbstractParentExprNode) {
                    ((AbstractParentExprNode)exprNode).setType(resolvedType);
                    continue;
                }
                throw new AssertionError((Object)("Unhandled type: " + exprNode));
            }
        }
        this.checkReportedAllInvalidNames();
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void checkReportedAllInvalidNames() {
        Preconditions.checkState((boolean)this.invalidTemplateNames.equals(this.reportedInvalidTemplateNames), (Object)("Expected: " + this.invalidTemplateNames + "; found: " + this.reportedInvalidTemplateNames));
    }

    private class TemplateTypeUpgrader
    implements SoyTypeVisitor<SoyType> {
        private final SourceLocation whereToReportErrors;
        private final TemplateRegistry templateRegistry;
        private final boolean isTemplateLiteral;
        private final boolean isSynthetic;

        private TemplateTypeUpgrader(SourceLocation whereToReportErrors, TemplateRegistry templateRegistry, boolean isTemplateLiteral, boolean isSynthetic) {
            this.whereToReportErrors = whereToReportErrors;
            this.templateRegistry = templateRegistry;
            this.isTemplateLiteral = isTemplateLiteral;
            this.isSynthetic = isSynthetic;
        }

        @Override
        public SoyType visit(ErrorType type) {
            return type;
        }

        @Override
        public SoyType visit(LegacyObjectMapType type) {
            if (type.getKeyType() == null && type.getValueType() == null) {
                return type;
            }
            SoyType key = type.getKeyType().accept(this);
            SoyType value = type.getValueType().accept(this);
            return UpgradeTemplateTypesPass.this.typeRegistry.getOrCreateLegacyObjectMapType(key, value);
        }

        @Override
        public SoyType visit(ListType type) {
            if (type.getElementType() == null) {
                return type;
            }
            SoyType element = type.getElementType().accept(this);
            return UpgradeTemplateTypesPass.this.typeRegistry.getOrCreateListType(element);
        }

        @Override
        public SoyType visit(MapType type) {
            if (type.getKeyType() == null && type.getValueType() == null) {
                return type;
            }
            SoyType key = type.getKeyType().accept(this);
            SoyType value = type.getValueType().accept(this);
            return UpgradeTemplateTypesPass.this.typeRegistry.getOrCreateMapType(key, value);
        }

        @Override
        public SoyType visit(NamedTemplateType type) {
            TemplateMetadata basicTemplateOrElement = this.templateRegistry.getBasicTemplateOrElement(type.getTemplateName());
            if (basicTemplateOrElement == null) {
                if (this.isSynthetic) {
                    return UnknownType.getInstance();
                }
                return ErrorType.getInstance();
            }
            if (basicTemplateOrElement.getTemplateKind() != TemplateType.TemplateKind.BASIC && !this.isSynthetic) {
                UpgradeTemplateTypesPass.this.invalidTemplateNames.add(type.getTemplateName());
                if (this.isTemplateLiteral) {
                    UpgradeTemplateTypesPass.this.errorReporter.report(this.whereToReportErrors, ONLY_BASIC_TEMPLATES_ALLOWED, new Object[]{basicTemplateOrElement.getTemplateKind()});
                    UpgradeTemplateTypesPass.this.reportedInvalidTemplateNames.add(type.getTemplateName());
                }
                return ErrorType.getInstance();
            }
            if (basicTemplateOrElement.getContentKind() == SanitizedContentKind.HTML && !basicTemplateOrElement.isStrictHtml() && !this.isSynthetic) {
                UpgradeTemplateTypesPass.this.invalidTemplateNames.add(type.getTemplateName());
                if (this.isTemplateLiteral) {
                    UpgradeTemplateTypesPass.this.errorReporter.report(this.whereToReportErrors, ONLY_STRICT_HTML_TEMPLATES_ALLOWED, basicTemplateOrElement.getTemplateName());
                    UpgradeTemplateTypesPass.this.reportedInvalidTemplateNames.add(type.getTemplateName());
                }
                return ErrorType.getInstance();
            }
            TemplateType templateType = UpgradeTemplateTypesPass.this.typeRegistry.internTemplateType(TemplateMetadata.asTemplateType(basicTemplateOrElement));
            if (type.getBoundParameters().isPresent()) {
                return TemplateBindingUtil.bindParameters(templateType, (RecordType)type.getBoundParameters().get().accept(this), UpgradeTemplateTypesPass.this.typeRegistry, UpgradeTemplateTypesPass.this.errorReporter, this.whereToReportErrors);
            }
            return templateType;
        }

        @Override
        public SoyType visit(PrimitiveType type) {
            return type;
        }

        @Override
        public SoyType visit(RecordType type) {
            ArrayList<RecordType.Member> memberTypes = new ArrayList<RecordType.Member>();
            for (RecordType.Member member : type.getMembers()) {
                memberTypes.add(RecordType.memberOf(member.name(), member.type().accept(this)));
            }
            return UpgradeTemplateTypesPass.this.typeRegistry.getOrCreateRecordType(memberTypes);
        }

        @Override
        public SoyType visit(SoyProtoEnumType type) {
            return type;
        }

        @Override
        public SoyType visit(SoyProtoType type) {
            return type;
        }

        @Override
        public SoyType visit(TemplateType type) {
            Preconditions.checkState((!SoyTypes.transitivelyContainsKind(type, SoyType.Kind.NAMED_TEMPLATE) ? 1 : 0) != 0);
            return type;
        }

        @Override
        public SoyType visit(UnionType type) {
            ArrayList<SoyType> memberTypes = new ArrayList<SoyType>();
            for (SoyType memberType : type.getMembers()) {
                memberTypes.add(memberType.accept(this));
            }
            return UpgradeTemplateTypesPass.this.typeRegistry.getOrCreateUnionType(memberTypes);
        }

        @Override
        public SoyType visit(VeType type) {
            return type;
        }

        @Override
        public SoyType visit(MessageType type) {
            return type;
        }
    }
}

