/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.UpgradeTemplateTypesPass;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;

@RunAfter(value={UpgradeTemplateTypesPass.class})
final class TemplateTypeValidationPass
implements CompilerFileSetPass {
    private static final SoyErrorKind DECLARED_DEFAULT_TYPE_MISMATCH = SoyErrorKind.of("The initializer for ''{0}'' has type ''{1}'' which is not assignable to type ''{2}''.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    TemplateTypeValidationPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator, TemplateRegistry registry) {
        for (SoyFileNode file : sourceFiles) {
            for (TemplateNode templateNode : SoyTreeUtils.getAllNodesOfType(file, TemplateNode.class)) {
                for (TemplateHeaderVarDefn headerVar : templateNode.getHeaderParams()) {
                    SoyType actualType;
                    SoyType declaredType;
                    if (!SoyTypes.transitivelyContainsKind(headerVar.type(), SoyType.Kind.TEMPLATE) || headerVar.defaultValue() == null || (declaredType = headerVar.type()).isAssignableFrom(actualType = headerVar.defaultValue().getType())) continue;
                    this.errorReporter.report(headerVar.defaultValue().getSourceLocation(), DECLARED_DEFAULT_TYPE_MISMATCH, headerVar.name(), actualType, declaredType);
                }
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }
}

