/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.soytree.ImportsContext;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateMetadata;

public final class StrictDepsPass
implements CompilerFileSetPass {
    private static final SoyErrorKind CALL_TO_UNDEFINED_TEMPLATE = SoyErrorKind.of("Undefined template ''{0}''.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind CALL_TO_INDIRECT_DEPENDENCY = SoyErrorKind.of("Call is satisfied only by indirect dependency {0}. Add it as a direct dependency.", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ErrorReporter errorReporter;

    public StrictDepsPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        for (SoyFileNode file : sourceFiles) {
            for (TemplateLiteralNode node : SoyTreeUtils.getAllNodesOfType(file, TemplateLiteralNode.class)) {
                this.checkTemplateLiteralNode(node, file.getTemplateRegistry());
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void checkTemplateLiteralNode(TemplateLiteralNode node, ImportsContext.ImportsTemplateRegistry registry) {
        TemplateMetadata callee = registry.getBasicTemplateOrElement(node.getResolvedName());
        if (callee == null) {
            this.reportUndefinedTemplateErrors(node, registry);
        } else {
            SoyFileKind calleeKind = callee.getSoyFileKind();
            String callerFilePath = node.getSourceLocation().getFilePath();
            String calleeFilePath = callee.getSourceLocation().getFilePath();
            if (calleeKind == SoyFileKind.INDIRECT_DEP) {
                this.errorReporter.report(node.getSourceLocation(), CALL_TO_INDIRECT_DEPENDENCY, calleeFilePath);
            }
        }
    }

    private void reportUndefinedTemplateErrors(TemplateLiteralNode node, ImportsContext.ImportsTemplateRegistry registry) {
        Identifier ident = node.getIdentifier();
        String closestImportedSymbol = SoyErrors.getClosest(registry.getImportedSymbols(), ident.originalName());
        if (!Strings.isNullOrEmpty((String)closestImportedSymbol)) {
            closestImportedSymbol = "'" + closestImportedSymbol + "' (with no '.')";
        }
        String extraErrorMessage = SoyErrors.getDidYouMeanMessage(closestImportedSymbol, SoyErrors.getClosest(registry.getBasicTemplateOrElementNames(), ident.identifier()));
        this.errorReporter.report(node.getSourceLocation(), CALL_TO_UNDEFINED_TEMPLATE, ident.identifier(), extraErrorMessage);
    }
}

