/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.StrictHtmlValidationPass;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.HtmlElementMetadataP;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.ImportsContext;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@RunAfter(value={StrictHtmlValidationPass.class})
public final class SoyElementPass
implements CompilerFileSetPass {
    private static final SoyErrorKind SOYELEMENT_CANNOT_BE_SKIPPED = SoyErrorKind.of("Soy elements cannot be skipped.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOYELEMENT_CANNOT_WRAP_ITSELF_RECURSIVELY = SoyErrorKind.of("The root node of Soy elements must not recursively call itself. The cycle is ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOYELEMENT_CANNOT_WRAP_SOY_ELEMENT = SoyErrorKind.of("The root node of Soy elements must not be another Soy element.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ROOT_HAS_KEY_NODE = SoyErrorKind.of("The root node of Soy elements must not have a key. Instead, consider wrapping the Soy element in a keyed tag node.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ROOT_IS_DYNAMIC_TAG = SoyErrorKind.of("The root node of Soy elements must not be a dynamic HTML tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_ELEMENT_OPEN_TAG_CLOSE_AMBIGUOUS = SoyErrorKind.of("Soy element open tags must map to exactly one close tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_ELEMENT_EXACTLY_ONE_TAG = SoyErrorKind.of("Soy elements must contain exactly one top-level HTML element (e.g, span, div). Calls to templates (but not deltemplates) that contain one top-level HTML element are also allowed.", new SoyErrorKind.StyleAllowance[0]);
    static final ImmutableSet<SoyNode.Kind> ALLOWED_CHILD_NODES = Sets.immutableEnumSet((Enum)SoyNode.Kind.LET_CONTENT_NODE, (Enum[])new SoyNode.Kind[]{SoyNode.Kind.LET_VALUE_NODE, SoyNode.Kind.DEBUGGER_NODE, SoyNode.Kind.LOG_NODE});
    private static final HtmlElementMetadataP DEFAULT_HTML_METADATA = HtmlElementMetadataP.newBuilder().setIsHtmlElement(false).setIsVelogged(false).build();
    private static final String DYNAMIC_ELEMENT_TAG = "?";
    private final ErrorReporter errorReporter;

    SoyElementPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        LinkedHashMap<String, TemplateNode> templatesInLibrary = new LinkedHashMap<String, TemplateNode>();
        for (SoyFileNode file : sourceFiles) {
            for (TemplateNode template : file.getTemplates()) {
                if (!(template instanceof TemplateDelegateNode) && template.getContentKind() == SanitizedContentKind.HTML) {
                    templatesInLibrary.put(template.getTemplateName(), template);
                    continue;
                }
                template.setHtmlElementMetadata(DEFAULT_HTML_METADATA);
            }
        }
        for (TemplateNode template : templatesInLibrary.values()) {
            HashSet<TemplateNode> visited = new HashSet<TemplateNode>();
            this.getTemplateMetadata(template, templatesInLibrary, template.getParent().getTemplateRegistry(), visited);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private HtmlElementMetadataP getTemplateMetadata(TemplateNode template, Map<String, TemplateNode> templatesInLibrary, ImportsContext.ImportsTemplateRegistry registry, Set<TemplateNode> visited) {
        if (visited.contains(template)) {
            if (template instanceof TemplateElementNode) {
                this.errorReporter.report(template.getSourceLocation(), SOYELEMENT_CANNOT_WRAP_ITSELF_RECURSIVELY, visited.stream().map(TemplateNode::getTemplateName).sorted().collect(ImmutableSet.toImmutableSet()));
            }
            template.setHtmlElementMetadata(DEFAULT_HTML_METADATA);
            return null;
        }
        visited.add(template);
        boolean isSoyElement = template instanceof TemplateElementNode;
        VeLogNode veLogNode = null;
        HtmlOpenTagNode openTag = null;
        HtmlTagNode closeTag = null;
        for (int i = 0; i < template.numChildren(); ++i) {
            Node child = template.getChild(i);
            if (ALLOWED_CHILD_NODES.contains((Object)child.getKind())) continue;
            if (openTag == null && child instanceof CallBasicNode && ((CallBasicNode)child).isStaticCall() && i == template.numChildren() - 1) {
                return this.getTemplateMetadataForStaticCall(template, (CallBasicNode)child, templatesInLibrary, registry, visited);
            }
            if (openTag == null && child instanceof HtmlOpenTagNode) {
                closeTag = SoyElementPass.checkHtmlOpenTag(template, (HtmlOpenTagNode)child, this.errorReporter, isSoyElement);
                if (closeTag == null) break;
                i = template.getChildIndex(closeTag);
                openTag = (HtmlOpenTagNode)child;
                continue;
            }
            if (openTag == null && child instanceof VeLogNode) {
                veLogNode = (VeLogNode)child;
                HtmlOpenTagNode maybeOpenTagNode = veLogNode.getOpenTagNode();
                if (maybeOpenTagNode == null) continue;
                closeTag = SoyElementPass.checkHtmlOpenTag(veLogNode, maybeOpenTagNode, this.errorReporter, isSoyElement);
                if (closeTag == null) break;
                openTag = maybeOpenTagNode;
                continue;
            }
            openTag = null;
            closeTag = null;
            if (!isSoyElement) break;
            this.errorReporter.report(child.getSourceLocation(), SOY_ELEMENT_EXACTLY_ONE_TAG, new Object[0]);
            break;
        }
        if (openTag != null) {
            openTag.setElementRoot();
        }
        boolean isValid = openTag != null && closeTag != null;
        HtmlElementMetadataP.Builder builder = HtmlElementMetadataP.newBuilder();
        boolean hasSkipNode = false;
        if (isValid) {
            for (SoyNode.StandaloneNode child : openTag.getChildren()) {
                if (!(child instanceof SkipNode)) continue;
                hasSkipNode = true;
            }
            builder.setTag(openTag.getTagName().isStatic() ? openTag.getTagName().getStaticTagName() : DYNAMIC_ELEMENT_TAG);
            if (hasSkipNode && template instanceof TemplateElementNode) {
                this.errorReporter.report(openTag.getSourceLocation(), SOYELEMENT_CANNOT_BE_SKIPPED, new Object[0]);
            }
        }
        HtmlElementMetadataP info = builder.setIsHtmlElement(isValid).setIsVelogged(veLogNode != null).setIsSkip(hasSkipNode).build();
        template.setHtmlElementMetadata(info);
        return info;
    }

    private HtmlElementMetadataP getTemplateMetadataForStaticCall(TemplateNode template, CallBasicNode call, Map<String, TemplateNode> templatesInLibrary, ImportsContext.ImportsTemplateRegistry registry, Set<TemplateNode> visited) {
        String callee = call.getCalleeName();
        HtmlElementMetadataP calleeMetadata = null;
        boolean isCalleeSoyElement = false;
        TemplateMetadata templateMetadata = registry.getBasicTemplateOrElement(callee);
        if (templateMetadata != null) {
            calleeMetadata = templateMetadata.getHtmlElement();
            isCalleeSoyElement = templateMetadata.getSoyElement().getIsSoyElement();
        } else if (templatesInLibrary.containsKey(callee)) {
            TemplateNode calledTemplate = templatesInLibrary.get(callee);
            calleeMetadata = calledTemplate.getHtmlElementMetadata();
            if (calleeMetadata == null && (calleeMetadata = this.getTemplateMetadata(calledTemplate, templatesInLibrary, registry, visited)) == null) {
                template.setHtmlElementMetadata(DEFAULT_HTML_METADATA);
                return null;
            }
            isCalleeSoyElement = calledTemplate instanceof TemplateElementNode;
        } else {
            isCalleeSoyElement = false;
            calleeMetadata = DEFAULT_HTML_METADATA;
        }
        template.setHtmlElementMetadata(calleeMetadata);
        if (template instanceof TemplateElementNode) {
            if (calleeMetadata.getIsSkip()) {
                this.errorReporter.report(call.getSourceLocation(), SOYELEMENT_CANNOT_BE_SKIPPED, new Object[0]);
            }
            if (isCalleeSoyElement) {
                this.errorReporter.report(call.getSourceLocation(), SOYELEMENT_CANNOT_WRAP_SOY_ELEMENT, new Object[0]);
            }
            if (!calleeMetadata.getIsHtmlElement()) {
                this.errorReporter.report(call.getSourceLocation(), SOY_ELEMENT_EXACTLY_ONE_TAG, new Object[0]);
            }
        }
        return calleeMetadata;
    }

    @Nullable
    static HtmlTagNode checkHtmlOpenTag(SoyNode.BlockNode parent, HtmlOpenTagNode openTagNode, ErrorReporter errorReporter, boolean isSoyElement) {
        if (isSoyElement) {
            SoyElementPass.validateNoKey(openTagNode, errorReporter);
            SoyElementPass.validateNoDynamicTag(openTagNode, errorReporter);
        }
        if (openTagNode.isSelfClosing() || openTagNode.getTagName().isDefinitelyVoid() && openTagNode.getTaggedPairs().isEmpty()) {
            return openTagNode;
        }
        if (openTagNode.getTaggedPairs().isEmpty()) {
            return openTagNode;
        }
        if (openTagNode.getTaggedPairs().size() == 1) {
            HtmlTagNode closeTag = openTagNode.getTaggedPairs().get(0);
            if (closeTag.getParent() != parent) {
                if (isSoyElement) {
                    errorReporter.report(openTagNode.getSourceLocation(), SOY_ELEMENT_OPEN_TAG_CLOSE_AMBIGUOUS, new Object[0]);
                }
                return null;
            }
            return closeTag;
        }
        if (isSoyElement) {
            errorReporter.report(openTagNode.getSourceLocation(), SOY_ELEMENT_OPEN_TAG_CLOSE_AMBIGUOUS, new Object[0]);
        }
        return null;
    }

    private static void validateNoKey(HtmlOpenTagNode firstTagNode, ErrorReporter errorReporter) {
        for (SoyNode child : firstTagNode.getChildren()) {
            if (!(child instanceof KeyNode)) continue;
            errorReporter.report(firstTagNode.getSourceLocation(), ROOT_HAS_KEY_NODE, new Object[0]);
        }
    }

    private static void validateNoDynamicTag(HtmlOpenTagNode firstTagNode, ErrorReporter errorReporter) {
        if (!firstTagNode.getTagName().isStatic()) {
            errorReporter.report(firstTagNode.getSourceLocation(), ROOT_IS_DYNAMIC_TAG, new Object[0]);
        }
    }
}

