/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.data.internalutils.InternalValueUtils;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.passes.CheckGlobalsPass;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.passes.VeRewritePass;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;

@RunAfter(value={VeRewritePass.class})
@RunBefore(value={CheckGlobalsPass.class})
final class RewriteGlobalsPass
implements CompilerFilePass {
    private static final SoyErrorKind ENUM_MEMBERSHIP_ERROR = SoyErrorKind.of("''{0}'' is not a member of enum ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PROTO_GLOBAL_OVERLAP_ERROR = SoyErrorKind.of("''{0}'' corresponds to a proto enum and is registered as a global with the value ''{1}''.  Remove the global definition.", new SoyErrorKind.StyleAllowance[0]);
    private final ImmutableMap<String, PrimitiveData> compileTimeGlobals;
    private final ErrorReporter errorReporter;

    RewriteGlobalsPass(ImmutableMap<String, PrimitiveData> compileTimeGlobals, ErrorReporter errorReporter) {
        this.compileTimeGlobals = compileTimeGlobals;
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        SoyTypeRegistry typeRegistry = file.getSoyTypeRegistry();
        for (GlobalNode global : SoyTreeUtils.getAllNodesOfType(file, GlobalNode.class)) {
            this.resolveGlobal(file, typeRegistry, global);
        }
    }

    private void resolveGlobal(SoyFileNode file, SoyTypeRegistry typeRegistry, GlobalNode global) {
        PrimitiveData value;
        String enumTypeName;
        SoyType type;
        String name = global.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot > 0 && (type = typeRegistry.getType(enumTypeName = name.substring(0, lastDot))) != null && type.getKind() == SoyType.Kind.PROTO_ENUM) {
            SoyProtoEnumType enumType = (SoyProtoEnumType)type;
            String enumMemberName = name.substring(lastDot + 1);
            Integer enumValue = enumType.getValue(enumMemberName);
            if (enumValue != null) {
                global.resolve(enumType, new IntegerNode(enumValue.intValue(), global.getSourceLocation()));
                String fullyQualifiedName = enumType.getName() + "." + enumMemberName;
                PrimitiveData value2 = (PrimitiveData)this.compileTimeGlobals.get((Object)fullyQualifiedName);
                if (value2 != null) {
                    this.errorReporter.report(global.getSourceLocation(), PROTO_GLOBAL_OVERLAP_ERROR, fullyQualifiedName, value2);
                }
            } else {
                this.errorReporter.report(global.getSourceLocation(), ENUM_MEMBERSHIP_ERROR, enumMemberName, enumTypeName);
            }
            return;
        }
        Identifier alias = file.resolveAlias(global.getIdentifier());
        if (alias != null) {
            global.setName(alias.identifier());
        }
        if ((value = (PrimitiveData)this.compileTimeGlobals.get((Object)(name = global.getName()))) != null) {
            SoyType type2;
            ExprNode.PrimitiveNode expr = InternalValueUtils.convertPrimitiveDataToExpr(value, global.getSourceLocation());
            global.resolve(expr.getType(), expr);
            lastDot = name.lastIndexOf(46);
            if (lastDot > 0 && (type2 = typeRegistry.getProtoRegistry().getProtoType(name.substring(0, lastDot))) != null) {
                this.errorReporter.report(global.getSourceLocation(), PROTO_GLOBAL_OVERLAP_ERROR, name, value);
            }
        }
    }
}

