/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.ResolvePluginsPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import java.util.List;

@RunAfter(value={ResolvePluginsPass.class})
@RunBefore(value={ResolveExpressionTypesPass.class})
final class RewriteDirectivesCallableAsFunctionsPass
implements CompilerFilePass {
    private static final SoyErrorKind NOT_FIRST_PRINT_DIRECTIVE = SoyErrorKind.of("Function ''{0}'' cannot be called as a print directive when preceded by print directive ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    RewriteDirectivesCallableAsFunctionsPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (PrintDirectiveNode directiveNode : SoyTreeUtils.getAllNodesOfType(file, PrintDirectiveNode.class)) {
            SoySourceFunction function = directiveNode.getPrintDirectiveFunction();
            if (function == null) continue;
            this.rewritePrintDirectiveAsFunction(directiveNode, function);
        }
    }

    private void rewritePrintDirectiveAsFunction(PrintDirectiveNode directiveNode, SoySourceFunction function) {
        PrintNode printNode = (PrintNode)directiveNode.getParent();
        String functionName = function.getClass().getAnnotation(SoyFunctionSignature.class).name();
        int directiveIndex = printNode.getChildIndex(directiveNode);
        if (directiveIndex != 0) {
            this.errorReporter.report(directiveNode.getSourceLocation(), NOT_FIRST_PRINT_DIRECTIVE, functionName, ((PrintDirectiveNode)printNode.getChild(directiveIndex - 1)).getName());
            return;
        }
        ExprRootNode originalExprRoot = printNode.getExpr();
        ExprNode originalExpr = originalExprRoot.getRoot();
        FunctionNode newExpr = new FunctionNode(Identifier.create(functionName, directiveNode.getNameLocation()), function, originalExpr.getSourceLocation().extend(directiveNode.getSourceLocation()));
        newExpr.addChild(originalExpr);
        newExpr.addChildren((List<? extends ExprNode>)directiveNode.getArgs());
        originalExprRoot.addChild(newExpr);
        printNode.removeChild(directiveIndex);
    }
}

