/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.UnknownType;
import com.google.template.soy.types.ast.TypeNodeConverter;

final class ResolveTemplateParamTypesPass
implements CompilerFilePass {
    private final ErrorReporter errorReporter;
    private final boolean disableAllTypeChecking;

    ResolveTemplateParamTypesPass(ErrorReporter errorReporter, boolean disableAllTypeChecking) {
        this.errorReporter = errorReporter;
        this.disableAllTypeChecking = disableAllTypeChecking;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        TypeNodeConverter converter = TypeNodeConverter.builder(this.errorReporter).setTypeRegistry(file.getSoyTypeRegistry()).setDisableAllTypeChecking(this.disableAllTypeChecking).build();
        for (TemplateNode template : file.getTemplates()) {
            for (TemplateParam param : template.getAllParams()) {
                if (param.getTypeNode() != null) {
                    param.setType(converter.getOrCreateType(param.getTypeNode()));
                    continue;
                }
                if (!this.disableAllTypeChecking) continue;
                param.setType(UnknownType.getInstance());
            }
            if (!(template instanceof TemplateElementNode)) continue;
            for (TemplateStateVar state : ((TemplateElementNode)template).getStateVars()) {
                if (state.getTypeNode() == null) continue;
                state.setType(converter.getOrCreateType(state.getTypeNode()));
            }
        }
    }
}

