/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.ResolveTemplateImportsPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.passes.SoyElementPass;
import com.google.template.soy.soytree.ImportsContext;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplatesPerFile;
import java.util.Optional;

@RunAfter(value={ResolveTemplateImportsPass.class})
@RunBefore(value={SoyElementPass.class})
public final class ResolveTemplateNamesPass
implements CompilerFileSetPass {
    private static final SoyErrorKind CALL_COLLIDES_WITH_NAMESPACE_ALIAS = SoyErrorKind.of("Call collides with namespace alias ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_CALLEE_NAMESPACE = SoyErrorKind.of("Callee ''{0}'' should be relative to a namespace (preceded by a \".\"), or it must be imported. {1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ErrorReporter errorReporter;

    public ResolveTemplateNamesPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        UnmodifiableIterator unmodifiableIterator = sourceFiles.iterator();
        while (unmodifiableIterator.hasNext()) {
            SoyFileNode file;
            this.visitFile(file, (file = (SoyFileNode)unmodifiableIterator.next()).hasTemplateRegistry() ? Optional.of(file.getTemplateRegistry()) : Optional.empty());
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void visitFile(SoyFileNode file, Optional<ImportsContext.ImportsTemplateRegistry> templateRegistry) {
        for (TemplateLiteralNode node : SoyTreeUtils.getAllNodesOfType(file, TemplateLiteralNode.class)) {
            this.resolveTemplateName(node, templateRegistry, file.getHeaderInfo());
        }
    }

    private void resolveTemplateName(TemplateLiteralNode templateLiteralNode, Optional<ImportsContext.ImportsTemplateRegistry> importsTemplateRegistry, TemplateNode.SoyFileHeaderInfo header) {
        TemplatesPerFile.TemplateName importedTemplate;
        if (templateLiteralNode.isResolved()) {
            return;
        }
        Identifier unresolvedIdent = templateLiteralNode.getIdentifier();
        String name = unresolvedIdent.identifier();
        if (importsTemplateRegistry.isPresent() && (importedTemplate = (TemplatesPerFile.TemplateName)importsTemplateRegistry.get().getSymbolsToTemplateNamesMap().get((Object)name)) != null) {
            templateLiteralNode.resolveTemplateName(Identifier.create(importedTemplate.fullyQualifiedName(), name, unresolvedIdent.location()));
            return;
        }
        switch (unresolvedIdent.type()) {
            case DOT_IDENT: {
                templateLiteralNode.resolveTemplateName(Identifier.create(header.getNamespace() + name, name, unresolvedIdent.location()));
                return;
            }
            case DOTTED_IDENT: {
                templateLiteralNode.resolveTemplateName(header.resolveAlias(unresolvedIdent));
                return;
            }
            case SINGLE_IDENT: {
                this.reportUnresolveableTemplateNameError(unresolvedIdent, header, importsTemplateRegistry);
                templateLiteralNode.resolveTemplateName(unresolvedIdent);
                return;
            }
        }
        throw new AssertionError((Object)unresolvedIdent.type());
    }

    private void reportUnresolveableTemplateNameError(Identifier unresolvedTemplateNameIdent, TemplateNode.SoyFileHeaderInfo header, Optional<ImportsContext.ImportsTemplateRegistry> importsTemplateRegistry) {
        String unresolvedName = unresolvedTemplateNameIdent.identifier();
        if (header.hasAlias(unresolvedName)) {
            this.errorReporter.report(unresolvedTemplateNameIdent.location(), CALL_COLLIDES_WITH_NAMESPACE_ALIAS, unresolvedName);
            return;
        }
        String importSuggestion = "";
        if (importsTemplateRegistry.isPresent() && !Strings.isNullOrEmpty((String)(importSuggestion = SoyErrors.getClosest(importsTemplateRegistry.get().getImportedSymbols(), unresolvedName)))) {
            importSuggestion = "'" + importSuggestion + "' (with no '.')";
        }
        this.errorReporter.report(unresolvedTemplateNameIdent.location(), MISSING_CALLEE_NAMESPACE, unresolvedName, SoyErrors.getDidYouMeanMessage("." + unresolvedName, importSuggestion));
    }
}

