/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.ImportsPass;
import com.google.template.soy.passes.ResolveTemplateNamesPass;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.ImportsContext;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateNameRegistry;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.TemplatesPerFile;
import com.google.template.soy.soytree.defn.ImportedVar;
import java.util.LinkedHashMap;
import java.util.Map;

@RunBefore(value={ResolveTemplateNamesPass.class})
public final class ResolveTemplateImportsPass
extends ImportsPass
implements CompilerFileSetPass {
    private TemplateNameRegistry templateNameRegistry = null;
    private final SoyGeneralOptions options;
    private final ErrorReporter errorReporter;

    ResolveTemplateImportsPass(SoyGeneralOptions options, ErrorReporter errorReporter) {
        this.options = options;
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator nodeIdGen, TemplateNameRegistry templateNameRegistry, TemplateRegistry unusedPartialTemplateRegistry) {
        this.templateNameRegistry = templateNameRegistry;
        for (SoyFileNode sourceFile : sourceFiles) {
            this.visitFile(sourceFile);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    ErrorReporter errorReporter() {
        return this.errorReporter;
    }

    @Override
    TemplateImportVisitor createImportVisitorForFile(SoyFileNode file) {
        return new TemplateImportVisitor(file, this.templateNameRegistry, this.options, this.errorReporter);
    }

    static final class TemplateImportVisitor
    extends ImportsPass.ImportVisitor {
        private final TemplateNameRegistry templateNameRegistry;
        final Map<String, TemplatesPerFile.TemplateName> symbolsToTemplatesMap = new LinkedHashMap<String, TemplatesPerFile.TemplateName>();

        TemplateImportVisitor(SoyFileNode file, TemplateNameRegistry templateNameRegistry, SoyGeneralOptions options, ErrorReporter errorReporter) {
            super(file, (ImmutableSet<ImportNode.ImportType>)ImmutableSet.of((Object)((Object)ImportNode.ImportType.TEMPLATE)), options, errorReporter);
            this.templateNameRegistry = templateNameRegistry;
        }

        @Override
        void processImportedSymbols(ImportNode node) {
            TemplatesPerFile templatesPerFile = this.templateNameRegistry.getTemplatesForFile(node.getPath());
            for (ImportedVar symbol : node.getIdentifiers()) {
                String name = symbol.name();
                if (!templatesPerFile.hasTemplateWithUnqualifiedName(name)) {
                    this.reportUnknownSymbolError(symbol.nameLocation(), name, node.getPath(), (Iterable<String>)templatesPerFile.getUnqualifiedTemplateNames());
                    continue;
                }
                this.symbolsToTemplatesMap.put(symbol.aliasOrName(), templatesPerFile.getFullTemplateName(name));
            }
        }

        @Override
        void processImportedModule(ImportNode node) {
            TemplatesPerFile templatesPerFile = this.templateNameRegistry.getTemplatesForFile(node.getPath());
            templatesPerFile.getUnqualifiedTemplateNames().forEach(template -> this.symbolsToTemplatesMap.put(node.getModuleAlias() + "." + template, templatesPerFile.getFullTemplateName((String)template)));
        }

        @Override
        boolean importExists(ImportNode.ImportType type, String path) {
            return this.templateNameRegistry.hasFile(path);
        }

        @Override
        ImmutableSet<String> getValidImportPathsForType(ImportNode.ImportType type) {
            return this.templateNameRegistry.allFiles();
        }

        @Override
        void updateImportsContext() {
            this.file.getImportsContext().setTemplateRegistry(new ImportsContext.ImportsTemplateRegistry(this.file, (ImmutableMap<String, TemplatesPerFile.TemplateName>)ImmutableMap.copyOf(this.symbolsToTemplatesMap)));
        }
    }
}

