/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.internal.proto.Field;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.ImportsPass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.ResolvePluginsPass;
import com.google.template.soy.passes.ResolveTemplateParamTypesPass;
import com.google.template.soy.passes.RewriteGlobalsPass;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.ImportsContext;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@RunBefore(value={ResolveExpressionTypesPass.class, ResolvePluginsPass.class, ResolveTemplateParamTypesPass.class, ResolveExpressionTypesPass.class, RewriteGlobalsPass.class})
final class ResolveProtoImportsPass
extends ImportsPass
implements CompilerFilePass {
    private final SoyTypeRegistry typeRegistry;
    private final SoyGeneralOptions options;
    private final ErrorReporter errorReporter;
    private final boolean disableAllTypeChecking;
    private final ImmutableMap<String, Descriptors.FileDescriptor> pathToDescriptor;

    ResolveProtoImportsPass(SoyTypeRegistry typeRegistry, SoyGeneralOptions options, ErrorReporter errorReporter, boolean disableAllTypeChecking) {
        this.typeRegistry = typeRegistry;
        this.options = options;
        this.errorReporter = errorReporter;
        this.disableAllTypeChecking = disableAllTypeChecking;
        this.pathToDescriptor = (ImmutableMap)typeRegistry.getProtoDescriptors().stream().collect(ImmutableMap.toImmutableMap(Descriptors.FileDescriptor::getName, d -> d));
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        this.visitFile(file);
    }

    @Override
    ImportsPass.ImportVisitor createImportVisitorForFile(SoyFileNode file) {
        return new ProtoImportVisitor(file, this.typeRegistry, this.pathToDescriptor, this.options, this.errorReporter, this.disableAllTypeChecking);
    }

    private static final class ProtoImportVisitor
    extends ImportsPass.ImportVisitor {
        private final SoyTypeRegistry typeRegistry;
        private final boolean disableAllTypeChecking;
        private final ImmutableMap<String, Descriptors.FileDescriptor> pathToDescriptor;
        private final Map<String, String> msgAndEnumLocalToFqn = new HashMap<String, String>();
        private final Map<String, String> extLocalToFqn = new HashMap<String, String>();

        ProtoImportVisitor(SoyFileNode file, SoyTypeRegistry typeRegistry, ImmutableMap<String, Descriptors.FileDescriptor> pathToDescriptor, SoyGeneralOptions options, ErrorReporter errorReporter, boolean disableAllTypeChecking) {
            super(file, (ImmutableSet<ImportNode.ImportType>)ImmutableSet.of((Object)((Object)ImportNode.ImportType.PROTO)), options, errorReporter);
            this.pathToDescriptor = pathToDescriptor;
            this.typeRegistry = typeRegistry;
            this.disableAllTypeChecking = disableAllTypeChecking;
        }

        @Override
        void processImportedSymbols(ImportNode node) {
            if (this.disableAllTypeChecking) {
                return;
            }
            Descriptors.FileDescriptor fd = (Descriptors.FileDescriptor)this.pathToDescriptor.get((Object)node.getPath());
            ImmutableMap messages = (ImmutableMap)fd.getMessageTypes().stream().collect(ImmutableMap.toImmutableMap(Descriptors.Descriptor::getName, f -> f));
            ImmutableMap enums = (ImmutableMap)fd.getEnumTypes().stream().collect(ImmutableMap.toImmutableMap(Descriptors.EnumDescriptor::getName, f -> f));
            ImmutableMap extensions = (ImmutableMap)fd.getExtensions().stream().collect(ImmutableMap.toImmutableMap(Field::computeSoyName, f -> f));
            for (ImportedVar symbol : node.getIdentifiers()) {
                String name = symbol.name();
                String fullName = fd.getPackage().isEmpty() ? name : fd.getPackage() + "." + name;
                Descriptors.Descriptor messageDesc = (Descriptors.Descriptor)messages.get((Object)name);
                if (messageDesc != null) {
                    ProtoImportVisitor.putDistinct(this.msgAndEnumLocalToFqn, symbol.aliasOrName(), fullName);
                    continue;
                }
                Descriptors.EnumDescriptor enumDesc = (Descriptors.EnumDescriptor)enums.get((Object)name);
                if (enumDesc != null) {
                    ProtoImportVisitor.putDistinct(this.msgAndEnumLocalToFqn, symbol.aliasOrName(), fullName);
                    continue;
                }
                Descriptors.FieldDescriptor extDesc = (Descriptors.FieldDescriptor)extensions.get((Object)name);
                if (extDesc != null) {
                    ProtoImportVisitor.putDistinct(this.extLocalToFqn, symbol.aliasOrName(), fullName);
                    continue;
                }
                this.reportUnknownSymbolError(symbol.nameLocation(), name, node.getPath(), (Iterable<String>)Sets.union((Set)messages.keySet(), (Set)Sets.union((Set)enums.keySet(), (Set)extensions.keySet())));
            }
        }

        @Override
        void processImportedModule(ImportNode node) {
            String fullName;
            String moduleRelativeName;
            String symbol;
            if (this.disableAllTypeChecking) {
                return;
            }
            Descriptors.FileDescriptor fd = (Descriptors.FileDescriptor)this.pathToDescriptor.get((Object)node.getPath());
            for (Descriptors.FieldDescriptor ext : fd.getExtensions()) {
                symbol = Field.computeSoyName(ext);
                moduleRelativeName = node.getModuleAlias() + "." + symbol;
                fullName = fd.getPackage().isEmpty() ? symbol : fd.getPackage() + "." + symbol;
                ProtoImportVisitor.putDistinct(this.extLocalToFqn, moduleRelativeName, fullName);
            }
            for (Descriptors.GenericDescriptor descriptor : Iterables.concat((Iterable)fd.getMessageTypes(), (Iterable)fd.getEnumTypes())) {
                symbol = descriptor.getName();
                moduleRelativeName = node.getModuleAlias() + "." + symbol;
                fullName = fd.getPackage().isEmpty() ? symbol : fd.getPackage() + "." + symbol;
                ProtoImportVisitor.putDistinct(this.msgAndEnumLocalToFqn, moduleRelativeName, fullName);
            }
        }

        private static <K, V> void putDistinct(Map<K, V> into, K key, V value) {
            V old = into.put(key, value);
            if (old != null) {
                Preconditions.checkArgument((boolean)value.equals(old));
            }
        }

        @Override
        boolean importExists(ImportNode.ImportType importType, String path) {
            if (this.disableAllTypeChecking) {
                return true;
            }
            return this.pathToDescriptor.containsKey((Object)path);
        }

        @Override
        void updateImportsContext() {
            this.file.getImportsContext().setTypeRegistry(this.disableAllTypeChecking ? this.typeRegistry : new ImportsContext.ImportsTypeRegistry(this.typeRegistry, (ImmutableMap<String, String>)ImmutableMap.copyOf(this.msgAndEnumLocalToFqn), (ImmutableMap<String, String>)ImmutableMap.builder().putAll(this.msgAndEnumLocalToFqn).putAll(this.extLocalToFqn).build()));
        }

        @Override
        ImmutableSet<String> getValidImportPathsForType(ImportNode.ImportType type) {
            return this.pathToDescriptor.keySet();
        }
    }
}

