/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.PluginResolver;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.types.SoyType;
import java.util.Optional;

final class ResolvePluginsPass
implements CompilerFilePass {
    private final PluginResolver resolver;

    ResolvePluginsPass(PluginResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (FunctionNode function : SoyTreeUtils.getAllNodesOfType(file, FunctionNode.class)) {
            if (function.numChildren() == 0) {
                Identifier resolvedName = function.getIdentifier();
                SoyType type = file.getSoyTypeRegistry().getType(resolvedName.identifier());
                if (type == null) {
                    resolvedName = file.resolveAlias(resolvedName);
                    type = file.getSoyTypeRegistry().getType(resolvedName.identifier());
                }
                if (type != null && type.getKind() == SoyType.Kind.PROTO) {
                    ProtoInitNode protoInit = new ProtoInitNode(resolvedName, (Iterable<Identifier>)ImmutableList.of(), function.getSourceLocation());
                    function.getParent().replaceChild(function, protoInit);
                    continue;
                }
            }
            function.setSoyFunction(this.resolver.lookupSoyFunction(function.getFunctionName(), function.numChildren(), function.getSourceLocation()));
        }
        for (PrintDirectiveNode directiveNode : SoyTreeUtils.getAllNodesOfType(file, PrintDirectiveNode.class)) {
            String name = directiveNode.getName();
            Optional<SoySourceFunction> aliasedFunction = this.resolver.getFunctionCallableAsPrintDirective(name, directiveNode.getSourceLocation());
            if (aliasedFunction.isPresent()) {
                directiveNode.setPrintDirectiveFunction(aliasedFunction.get());
                continue;
            }
            directiveNode.setPrintDirective(this.resolver.lookupPrintDirective(name, directiveNode.getExprList().size(), directiveNode.getSourceLocation()));
        }
    }
}

