/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.UndeclaredVar;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ResolveNamesPass
implements CompilerFilePass {
    private static final SoyErrorKind GLOBAL_MATCHES_VARIABLE = SoyErrorKind.of("Found global reference aliasing a local variable ''{0}'', did you mean ''${0}''?", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind VARIABLE_ALREADY_DEFINED = SoyErrorKind.of("Variable ''${0}'' already defined{1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UKNOWN_VARIABLE = SoyErrorKind.of("Unknown variable.{0}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private LocalVariables localVariables;
    private final ErrorReporter errorReporter;

    public ResolveNamesPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        new Visitor().exec(file);
    }

    private static Optional<SourceLocation> forVarDefn(VarDefn varDefn) {
        switch (varDefn.kind()) {
            case PARAM: 
            case STATE: 
            case IMPORT_VAR: {
                return Optional.of(varDefn.nameLocation());
            }
            case LOCAL_VAR: {
                return Optional.of(((SoyNode.LocalVarNode)((LocalVar)varDefn).declaringNode()).getSourceLocation());
            }
            case COMPREHENSION_VAR: {
                return Optional.of(((ListComprehensionNode)((ListComprehensionNode.ComprehensionVarDefn)varDefn).declaringNode()).getSourceLocation());
            }
            case UNDECLARED: {
                return Optional.empty();
            }
        }
        throw new AssertionError((Object)varDefn.kind());
    }

    private final class ResolveNamesExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private ResolveNamesExprVisitor() {
        }

        @Override
        public Void exec(ExprNode node) {
            Preconditions.checkArgument((boolean)(node instanceof ExprRootNode));
            this.visit(node);
            return null;
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }

        @Override
        protected void visitListComprehensionNode(ListComprehensionNode node) {
            this.visit(node.getListExpr());
            ResolveNamesPass.this.localVariables.enterScope();
            ResolveNamesPass.this.localVariables.define(node.getListIterVar(), node);
            if (node.getIndexVar() != null) {
                ResolveNamesPass.this.localVariables.define(node.getIndexVar(), node);
            }
            if (node.getFilterExpr() != null) {
                this.visit(node.getFilterExpr());
            }
            this.visit(node.getListItemTransformExpr());
            ResolveNamesPass.this.localVariables.exitScope();
        }

        @Override
        protected void visitGlobalNode(GlobalNode node) {
            String globalName = node.getName();
            VarDefn varDefn = ResolveNamesPass.this.localVariables.lookup(globalName);
            if (varDefn != null) {
                node.suppressUnknownGlobalErrors();
                ResolveNamesPass.this.errorReporter.report(node.getSourceLocation(), GLOBAL_MATCHES_VARIABLE, globalName);
            }
        }

        @Override
        protected void visitVarRefNode(VarRefNode varRef) {
            if (varRef.getDefnDecl() != null) {
                return;
            }
            VarDefn varDefn = ResolveNamesPass.this.localVariables.lookup(varRef.getName());
            if (varDefn == null) {
                ResolveNamesPass.this.errorReporter.report(varRef.getSourceLocation(), UKNOWN_VARIABLE, SoyErrors.getDidYouMeanMessage(ResolveNamesPass.this.localVariables.allVariablesInScope(), varRef.getName()));
                varDefn = new UndeclaredVar(varRef.getName(), varRef.getSourceLocation());
            }
            varRef.setDefn(varDefn);
        }
    }

    private final class Visitor
    extends AbstractSoyNodeVisitor<Void> {
        private Visitor() {
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            ResolveNamesPass.this.localVariables = new LocalVariables();
            ResolveNamesPass.this.localVariables.enterScope();
            ResolveNamesExprVisitor exprVisitor = new ResolveNamesExprVisitor();
            for (TemplateHeaderVarDefn param : node.getHeaderParams()) {
                if (param.defaultValue() != null) {
                    exprVisitor.exec(param.defaultValue());
                }
                ResolveNamesPass.this.localVariables.define(param, node);
            }
            this.visitSoyNode(node);
            ResolveNamesPass.this.localVariables.exitScope();
            ResolveNamesPass.this.localVariables = null;
        }

        @Override
        protected void visitPrintNode(PrintNode node) {
            this.visitSoyNode(node);
        }

        @Override
        protected void visitLetValueNode(LetValueNode node) {
            this.visitExpressions(node);
            ResolveNamesPass.this.localVariables.define(node.getVar(), node);
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            ResolveNamesPass.this.localVariables.enterScope();
            this.visitChildren(node);
            ResolveNamesPass.this.localVariables.exitScope();
            ResolveNamesPass.this.localVariables.define(node.getVar(), node);
        }

        @Override
        protected void visitForNonemptyNode(ForNonemptyNode node) {
            this.visitExpressions(node.getParent());
            ResolveNamesPass.this.localVariables.enterScope();
            ResolveNamesPass.this.localVariables.define(node.getVar(), node);
            if (node.getIndexVar() != null) {
                ResolveNamesPass.this.localVariables.define(node.getIndexVar(), node);
            }
            this.visitChildren(node);
            ResolveNamesPass.this.localVariables.exitScope();
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ExprHolderNode) {
                this.visitExpressions((SoyNode.ExprHolderNode)node);
            }
            if (node instanceof SoyNode.ParentSoyNode) {
                if (node instanceof SoyNode.BlockNode) {
                    ResolveNamesPass.this.localVariables.enterScope();
                    this.visitChildren((SoyNode.BlockNode)node);
                    ResolveNamesPass.this.localVariables.exitScope();
                } else {
                    this.visitChildren((SoyNode.ParentSoyNode)node);
                }
            }
        }

        private void visitExpressions(SoyNode.ExprHolderNode node) {
            ResolveNamesExprVisitor exprVisitor = new ResolveNamesExprVisitor();
            for (ExprRootNode expr : node.getExprList()) {
                exprVisitor.exec(expr);
            }
        }
    }

    private final class LocalVariables {
        private final Deque<Map<String, VarDefn>> currentScope = new ArrayDeque<Map<String, VarDefn>>();

        private LocalVariables() {
        }

        void enterScope() {
            this.currentScope.push(new LinkedHashMap());
        }

        void exitScope() {
            this.currentScope.pop();
        }

        VarDefn lookup(String name) {
            for (Map<String, VarDefn> scope : this.currentScope) {
                VarDefn defn = scope.get(name);
                if (defn == null) continue;
                return defn;
            }
            return null;
        }

        boolean define(VarDefn defn, Node definingNode) {
            VarDefn preexisting = this.lookup(defn.name());
            if (preexisting != null) {
                Optional preexistingSourceLocation = ResolveNamesPass.forVarDefn(preexisting);
                SourceLocation defnSourceLocation = defn.nameLocation() == null ? definingNode.getSourceLocation() : defn.nameLocation();
                String location = preexistingSourceLocation.isPresent() ? " at line " + ((SourceLocation)preexistingSourceLocation.get()).getBeginLine() : "";
                ResolveNamesPass.this.errorReporter.report(defnSourceLocation, VARIABLE_ALREADY_DEFINED, defn.name(), location);
                return false;
            }
            this.currentScope.peek().put(defn.name(), defn);
            return true;
        }

        List<String> allVariablesInScope() {
            return this.currentScope.stream().flatMap(map -> map.keySet().stream()).collect(Collectors.toList());
        }
    }
}

