/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.ResolvePluginsPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TagName;
import java.util.HashSet;

@RunAfter(value={ResolvePluginsPass.class})
@RunBefore(value={ResolveExpressionTypesPass.class})
final class LegacyTagNamePass
implements CompilerFilePass {
    private static final SoyErrorKind ILLEGAL_USE = SoyErrorKind.of("''legacyDynamicTag'' may only be used to name an HTML tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NEED_WRAP = SoyErrorKind.of("A dynamic tag name should be wrapped in the ''legacyDynamicTag'' function.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    LegacyTagNamePass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        HashSet<FunctionNode> correctlyPlaced = new HashSet<FunctionNode>();
        for (HtmlTagNode tagNode : SoyTreeUtils.getAllNodesOfType(file, HtmlTagNode.class)) {
            TagName name = tagNode.getTagName();
            if (name.isStatic()) continue;
            PrintNode printNode = name.getDynamicTagName();
            ExprNode exprNode = printNode.getExpr().getRoot();
            if (exprNode.getKind() == ExprNode.Kind.FUNCTION_NODE && ((FunctionNode)exprNode).getSoyFunction() == BuiltinFunction.LEGACY_DYNAMIC_TAG) {
                FunctionNode functionNode = (FunctionNode)exprNode;
                if (functionNode.numChildren() == 1) {
                    printNode.getExpr().clearChildren();
                    printNode.getExpr().addChild(functionNode.getChild(0));
                }
                correctlyPlaced.add(functionNode);
                continue;
            }
            this.errorReporter.warn(printNode.getExpr().getSourceLocation(), NEED_WRAP, new Object[0]);
        }
        for (FunctionNode fn : SoyTreeUtils.getAllFunctionInvocations(file, BuiltinFunction.LEGACY_DYNAMIC_TAG)) {
            if (correctlyPlaced.contains(fn)) continue;
            this.errorReporter.report(fn.getSourceLocation(), ILLEGAL_USE, new Object[0]);
        }
    }
}

