/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.UnionType;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

final class KeyCommandPass
implements CompilerFilePass {
    private static final SoyErrorKind KEY_ATTR_DIRECT_CHILD_OF_OPEN_TAG = SoyErrorKind.of("The `key` command must be directly nested within an HTML open tag (e.g. `<div '{'key 'foo''}'></div>`).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_KEY_ATTR = SoyErrorKind.of("The key attribute is deprecated. Instead, use the '{'key'}' command.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNSUPPORTED_TYPE = SoyErrorKind.of("Unsupported type ''{0}'': keys must be of type string, integer, or enum.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind KEY_ELEMENT_AMBIGUOUS = SoyErrorKind.of("Key elements must have open tags that map to a single HTML close tag and vice versa.", new SoyErrorKind.StyleAllowance[0]);
    private final boolean disableAllTypeChecking;
    private final ErrorReporter errorReporter;

    KeyCommandPass(ErrorReporter errorReporter, boolean disableAllTypeChecking) {
        this.disableAllTypeChecking = disableAllTypeChecking;
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (KeyNode node : SoyTreeUtils.getAllNodesOfType(file, KeyNode.class)) {
            this.checkNodeIsValidChildOfOpenTagNode(node);
            this.checkNoDuplicateKeyAttribute(node);
            if (this.disableAllTypeChecking) continue;
            this.checkNodeIsSupportedType(node.getExpr());
        }
        if (this.disableAllTypeChecking) {
            return;
        }
        for (CallNode call : SoyTreeUtils.getAllNodesOfType(file, CallNode.class)) {
            if (call.getKeyExpr() == null) continue;
            this.checkNodeIsSupportedType(call.getKeyExpr());
        }
    }

    private void checkNodeIsValidChildOfOpenTagNode(KeyNode node) {
        if (!(node.getParent() instanceof HtmlOpenTagNode)) {
            this.errorReporter.report(node.getSourceLocation(), KEY_ATTR_DIRECT_CHILD_OF_OPEN_TAG, new Object[0]);
            return;
        }
        HtmlOpenTagNode tagNode = (HtmlOpenTagNode)node.getParent();
        if (tagNode.getTaggedPairs().size() > 1) {
            this.errorReporter.report(node.getSourceLocation(), KEY_ELEMENT_AMBIGUOUS, new Object[0]);
            return;
        }
        if (tagNode.getTaggedPairs().size() != 0) {
            this.checkOneOpenTagNodeMappedToOneCloseTag(tagNode);
        }
    }

    private void checkOneOpenTagNodeMappedToOneCloseTag(HtmlOpenTagNode tagNode) {
        if (tagNode.getTaggedPairs().size() != 1) {
            this.errorReporter.report(tagNode.getSourceLocation(), KEY_ELEMENT_AMBIGUOUS, new Object[0]);
            return;
        }
        HtmlTagNode closeTag = tagNode.getTaggedPairs().get(0);
        if (closeTag.getTaggedPairs().size() != 1 || !Objects.equals(closeTag.getTaggedPairs().get(0), tagNode)) {
            this.errorReporter.report(tagNode.getSourceLocation(), KEY_ELEMENT_AMBIGUOUS, new Object[0]);
        }
    }

    private void checkNoDuplicateKeyAttribute(KeyNode node) {
        ParentNode parentNode = node.getParent();
        if (!(parentNode instanceof HtmlOpenTagNode)) {
            return;
        }
        HtmlAttributeNode keyAttrNode = ((HtmlOpenTagNode)parentNode).getDirectAttributeNamed("key");
        if (keyAttrNode != null) {
            this.errorReporter.report(keyAttrNode.getSourceLocation(), DUPLICATE_KEY_ATTR, new Object[0]);
        }
    }

    private void checkNodeIsSupportedType(ExprRootNode exprRootNode) {
        SoyType exprType = exprRootNode.getRoot().getType();
        Set<SoyType> unwrapped = exprType.getKind() == SoyType.Kind.UNION ? ((UnionType)exprType).getMembers() : ImmutableSet.of((Object)exprType);
        boolean isSupportedType = true;
        Iterator iterator = unwrapped.iterator();
        while (iterator.hasNext()) {
            SoyType type = (SoyType)iterator.next();
            switch (type.getKind()) {
                case ERROR: 
                case NULL: 
                case INT: 
                case FLOAT: 
                case STRING: 
                case PROTO_ENUM: {
                    break;
                }
                case BOOL: 
                case HTML: 
                case ATTRIBUTES: 
                case JS: 
                case CSS: 
                case URI: 
                case TRUSTED_RESOURCE_URI: 
                case LIST: 
                case RECORD: 
                case LEGACY_OBJECT_MAP: 
                case MAP: 
                case MESSAGE: 
                case PROTO: 
                case NAMED_TEMPLATE: 
                case TEMPLATE: 
                case VE: 
                case VE_DATA: 
                case ANY: 
                case UNKNOWN: {
                    isSupportedType = false;
                    break;
                }
                case UNION: {
                    throw new AssertionError((Object)"impossible");
                }
            }
        }
        if (!isSupportedType) {
            this.errorReporter.report(exprRootNode.getSourceLocation(), UNSUPPORTED_TYPE, exprType);
        }
    }
}

