/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TypeRegistries;
import java.util.HashMap;
import java.util.Map;

abstract class ImportsPass {
    private static final SoyErrorKind IMPORT_NOT_IN_DEPS = SoyErrorKind.of("Unknown import dep {0}.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNKNOWN_SYMBOL = SoyErrorKind.of("Unknown symbol {0} in {1}.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind SYMBOLS_NOT_ALLOWED = SoyErrorKind.of("Imported symbols are not allowed from import type {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SYMBOLS_REQUIRED = SoyErrorKind.of("One or more imported symbols are required for import type {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind IMPORT_COLLISION = SoyErrorKind.of("Imported symbol {0} conflicts with previously imported symbol.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind IMPORT_CONFLICTS_WITH_GLOBAL = SoyErrorKind.of("Import ''{0}'' conflicts with a global of the same name.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind IMPORT_CONFLICTS_WITH_GLOBAL_PREFIX = SoyErrorKind.of("Import ''{0}'' conflicts with namespace for global ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind IMPORT_CONFLICTS_WITH_TYPE_NAME = SoyErrorKind.of("Import ''{0}'' conflicts with a builtin type of the same name.", new SoyErrorKind.StyleAllowance[0]);

    ImportsPass() {
    }

    void visitFile(SoyFileNode file) {
        this.createImportVisitorForFile(file).exec();
    }

    abstract ImportVisitor createImportVisitorForFile(SoyFileNode var1);

    static abstract class ImportVisitor {
        final SoyFileNode file;
        private final SoyGeneralOptions options;
        final ErrorReporter errorReporter;
        private final ImmutableSet<ImportNode.ImportType> importTypesToVisit;
        private final Map<String, String> uniqueImports = new HashMap<String, String>();
        private Map<String, String> globalPrefixToFullNameMap = null;

        ImportVisitor(SoyFileNode file, ImmutableSet<ImportNode.ImportType> importTypesToVisit, SoyGeneralOptions options, ErrorReporter errorReporter) {
            this.file = file;
            this.options = options;
            this.importTypesToVisit = importTypesToVisit;
            this.errorReporter = errorReporter;
        }

        final void exec() {
            for (ImportNode importNode : this.file.getImports()) {
                this.visit(importNode);
            }
            this.updateImportsContext();
        }

        abstract void updateImportsContext();

        boolean shouldVisit(ImportNode node) {
            return true;
        }

        private void visit(ImportNode node) {
            if (!this.importTypesToVisit.contains((Object)node.getImportType()) || !this.shouldVisit(node)) {
                return;
            }
            if (!this.importExists(node.getImportType(), node.getPath())) {
                this.errorReporter.report(node.getPathSourceLocation(), IMPORT_NOT_IN_DEPS, node.getPath(), SoyErrors.getDidYouMeanMessage(this.getValidImportPathsForType(node.getImportType()), node.getPath()));
                return;
            }
            if (node.getImportType().allowsSymbols()) {
                if (node.getImportType().requiresSymbols() && node.getIdentifiers().isEmpty()) {
                    this.errorReporter.report(node.getSourceLocation(), SYMBOLS_REQUIRED, new Object[]{node.getImportType()});
                    return;
                }
                boolean foundSymbolErrors = false;
                for (ImportedVar symbol : node.getIdentifiers()) {
                    String duplicatePath;
                    String name = symbol.aliasOrName();
                    String path = node.getPath() + "//" + symbol.name();
                    if (path.equals(duplicatePath = this.uniqueImports.put(name, path)) || !this.reportErrorIfSymbolInvalid(this.file, name, symbol.nameLocation())) continue;
                    foundSymbolErrors = true;
                }
                if (foundSymbolErrors) {
                    return;
                }
            } else if (!node.getIdentifiers().isEmpty()) {
                this.errorReporter.report(((ImportedVar)node.getIdentifiers().get(0)).nameLocation(), SYMBOLS_NOT_ALLOWED, new Object[]{node.getImportType()});
                return;
            }
            if (node.isModuleImport()) {
                this.processImportedModule(node);
            } else {
                this.processImportedSymbols(node);
            }
        }

        abstract boolean importExists(ImportNode.ImportType var1, String var2);

        abstract void processImportedModule(ImportNode var1);

        abstract void processImportedSymbols(ImportNode var1);

        abstract ImmutableSet<String> getValidImportPathsForType(ImportNode.ImportType var1);

        void reportUnknownSymbolError(SourceLocation symbolLocation, String incorrectName, String importPath, Iterable<String> validSymbols) {
            this.errorReporter.report(symbolLocation, UNKNOWN_SYMBOL, incorrectName, importPath, SoyErrors.getDidYouMeanMessage(validSymbols, incorrectName));
        }

        boolean reportErrorIfSymbolInvalid(SoyFileNode file, String importSymbolName, SourceLocation nameLocation) {
            SoyType type;
            boolean foundErrors = false;
            if (!file.getImportsContext().addImportedSymbol(importSymbolName)) {
                this.errorReporter.report(nameLocation, IMPORT_COLLISION, importSymbolName);
                foundErrors = true;
            }
            if (this.options.getCompileTimeGlobals().containsKey((Object)importSymbolName)) {
                foundErrors = true;
                this.errorReporter.report(nameLocation, IMPORT_CONFLICTS_WITH_GLOBAL, importSymbolName);
            }
            if ((type = TypeRegistries.builtinTypeRegistry().getType(importSymbolName)) != null) {
                foundErrors = true;
                this.errorReporter.report(nameLocation, IMPORT_CONFLICTS_WITH_TYPE_NAME, importSymbolName);
            }
            String prefix = importSymbolName + ".";
            if (this.globalPrefixToFullNameMap == null) {
                this.globalPrefixToFullNameMap = this.buildGlobalPrefixToFullNameMap();
            }
            if (this.globalPrefixToFullNameMap.containsKey(prefix)) {
                foundErrors = true;
                this.errorReporter.report(nameLocation, IMPORT_CONFLICTS_WITH_GLOBAL_PREFIX, importSymbolName, this.globalPrefixToFullNameMap.get(prefix));
            }
            return foundErrors;
        }

        private ImmutableMap<String, String> buildGlobalPrefixToFullNameMap() {
            HashMap<String, String> prefixesToGlobalNamesBuilder = new HashMap<String, String>();
            UnmodifiableIterator unmodifiableIterator = this.options.getCompileTimeGlobals().keySet().iterator();
            while (unmodifiableIterator.hasNext()) {
                String fullName;
                String prefix = fullName = (String)unmodifiableIterator.next();
                int indexOfFirstDot = fullName.indexOf(".");
                if (indexOfFirstDot >= 0 && indexOfFirstDot < fullName.length() - 1) {
                    prefix = fullName.substring(0, indexOfFirstDot + 1);
                }
                prefixesToGlobalNamesBuilder.putIfAbsent(prefix, fullName);
            }
            return ImmutableMap.copyOf(prefixesToGlobalNamesBuilder);
        }
    }
}

