/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.shared.internal.BuiltinMethod;
import com.google.template.soy.shared.restricted.SoyMethod;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;

final class GetExtensionRewriteParamPass
implements CompilerFilePass {
    GetExtensionRewriteParamPass() {
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        SoyTreeUtils.getAllNodesOfType(file, MethodCallNode.class).stream().filter(MethodCallNode::isMethodResolved).filter(n -> {
            SoyMethod method = n.getSoyMethod();
            return method == BuiltinMethod.GET_EXTENSION;
        }).forEach(node -> {
            for (int i = 1; i < node.numChildren(); ++i) {
                ExprNode child = node.getChild(i);
                if (child.getKind() != ExprNode.Kind.GLOBAL_NODE) continue;
                node.replaceChild(i, (ExprNode)new StringNode(((GlobalNode)child).getName(), QuoteStyle.DOUBLE, child.getSourceLocation()));
            }
        });
    }
}

