/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlCommentNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.StringType;
import java.util.List;
import java.util.Optional;

public final class DesugarHtmlNodesPass
implements CompilerFileSetPass {
    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator, TemplateRegistry registry) {
        for (SoyFileNode fileNode : sourceFiles) {
            this.run(fileNode, idGenerator);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    @VisibleForTesting
    public void run(SoyNode node, IdGenerator idGenerator) {
        new RewritingVisitor(idGenerator).exec(node);
    }

    private static final class RewritingVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private final IdGenerator idGenerator;
        boolean needsSpaceForAttribute;
        boolean needsSpaceSelfClosingTag;
        private Optional<ImmutableList<SoyNode.StandaloneNode>> replacements = Optional.empty();

        RewritingVisitor(IdGenerator idGenerator) {
            this.idGenerator = idGenerator;
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            this.needsSpaceForAttribute = false;
            this.visitChildren(node);
        }

        private void visitHtmlTagNode(HtmlTagNode tag) {
            this.needsSpaceForAttribute = true;
            this.visitChildren(tag);
            this.replacements = tag.isSynthetic() ? Optional.of(ImmutableList.of()) : Optional.of(ImmutableList.builder().add((Object)this.createPrefix(tag instanceof HtmlOpenTagNode ? "<" : "</", tag)).addAll(tag.getChildren()).add((Object)this.createSuffix(tag instanceof HtmlOpenTagNode && ((HtmlOpenTagNode)tag).isSelfClosing() ? (this.needsSpaceSelfClosingTag ? " />" : "/>") : ">", tag)).build());
            this.needsSpaceForAttribute = false;
            this.needsSpaceSelfClosingTag = false;
        }

        @Override
        protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
            this.visitHtmlTagNode(node);
        }

        @Override
        protected void visitSkipNode(SkipNode skipNode) {
            HtmlOpenTagNode openTag = (HtmlOpenTagNode)skipNode.getParent();
            ImmutableList.Builder builder = ImmutableList.builder();
            FunctionNode wrappedFn = new FunctionNode(Identifier.create(BuiltinFunction.SOY_SERVER_KEY.getName(), openTag.getSourceLocation()), BuiltinFunction.SOY_SERVER_KEY, openTag.getSourceLocation());
            wrappedFn.setType(StringType.getInstance());
            if (openTag.getKeyNode() == null) {
                FunctionNode funcNode = new FunctionNode(Identifier.create(BuiltinFunction.XID.getName(), openTag.getSourceLocation()), BuiltinFunction.XID, openTag.getSourceLocation());
                funcNode.addChild(new StringNode(skipNode.getSkipId(), QuoteStyle.SINGLE, openTag.getSourceLocation()));
                funcNode.setType(StringType.getInstance());
                wrappedFn.addChild(funcNode);
            } else {
                wrappedFn.addChild(openTag.getKeyNode().getExpr().getRoot().copy(new CopyState()));
            }
            builder.add((Object)new RawTextNode(this.idGenerator.genId(), " soy-server-key=", openTag.getSourceLocation())).add((Object)this.createPrefix("'", skipNode)).add((Object)new PrintNode(this.idGenerator.genId(), openTag.getSourceLocation(), true, wrappedFn, (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding())).add((Object)this.createSuffix("'", skipNode));
            this.replacements = Optional.of(builder.build());
        }

        @Override
        protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
            this.visitHtmlTagNode(node);
        }

        @Override
        protected void visitHtmlCommentNode(HtmlCommentNode node) {
            this.visitChildren(node);
            this.replacements = Optional.of(ImmutableList.builder().add((Object)this.createPrefix("<!--", node)).addAll(node.getChildren()).add((Object)this.createSuffix("-->", node)).build());
        }

        @Override
        protected void visitHtmlAttributeValueNode(HtmlAttributeValueNode node) {
            this.visitChildren(node);
            HtmlAttributeValueNode.Quotes quotes = node.getQuotes();
            if (quotes == HtmlAttributeValueNode.Quotes.NONE) {
                this.replacements = Optional.of(ImmutableList.copyOf(node.getChildren()));
                this.needsSpaceSelfClosingTag = true;
            } else {
                this.replacements = Optional.of(ImmutableList.builder().add((Object)this.createPrefix(quotes.getQuotationCharacter(), node)).addAll(node.getChildren()).add((Object)this.createSuffix(quotes.getQuotationCharacter(), node)).build());
                this.needsSpaceSelfClosingTag = false;
            }
        }

        private RawTextNode createPrefix(String prefix, SoyNode context) {
            SourceLocation location = context.getSourceLocation().getBeginLocation();
            if (prefix.length() > 1) {
                location = location.offsetEndCol(prefix.length() - 1);
            }
            return new RawTextNode(this.idGenerator.genId(), prefix, location);
        }

        private RawTextNode createSuffix(String suffix, SoyNode context) {
            SourceLocation location = context.getSourceLocation().getEndLocation();
            if (suffix.length() > 1) {
                location = location.offsetEndCol(suffix.length() - 1);
            }
            return new RawTextNode(this.idGenerator.genId(), suffix, location);
        }

        @Override
        protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
            this.visitChildren(node);
            ImmutableList.Builder builder = ImmutableList.builder();
            if (this.needsSpaceForAttribute) {
                builder.add((Object)new RawTextNode(this.idGenerator.genId(), " ", node.getSourceLocation().getBeginLocation()));
            } else {
                this.needsSpaceForAttribute = true;
            }
            builder.add((Object)((SoyNode.StandaloneNode)node.getChild(0)));
            if (node.hasValue()) {
                builder.add((Object)new RawTextNode(this.idGenerator.genId(), "=", node.getEqualsLocation()));
                builder.addAll(node.getChildren().subList(1, node.numChildren()));
            }
            this.replacements = Optional.of(builder.build());
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            this.visitRenderUnitNode(node);
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.visitRenderUnitNode(node);
        }

        private void visitRenderUnitNode(SoyNode.RenderUnitNode node) {
            boolean prevNeedsSpaceForAttribute = this.needsSpaceForAttribute;
            this.needsSpaceForAttribute = false;
            boolean prevNeedsSpaceForSelfClosingTag = this.needsSpaceSelfClosingTag;
            this.needsSpaceSelfClosingTag = false;
            this.visitChildren(node);
            this.needsSpaceForAttribute = prevNeedsSpaceForAttribute;
            this.needsSpaceSelfClosingTag = prevNeedsSpaceForSelfClosingTag;
        }

        @Override
        protected void visitIfNode(IfNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitForNode(ForNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitMsgPluralNode(MsgPluralNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitMsgSelectNode(MsgSelectNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        private void visitControlFlowBranches(List<? extends SoyNode.ParentSoyNode<?>> branches) {
            boolean startNeedsSpaceForAttribute = this.needsSpaceForAttribute;
            boolean endNeedsSpaceForAttribute = this.needsSpaceForAttribute;
            boolean startNeedsSpaceForSelfClosingTag = this.needsSpaceSelfClosingTag;
            boolean endNeedsSpaceForSelfClosingTag = this.needsSpaceSelfClosingTag;
            for (SoyNode.ParentSoyNode<?> branch : branches) {
                this.visitChildren(branch);
                endNeedsSpaceForAttribute |= this.needsSpaceForAttribute;
                this.needsSpaceForAttribute = startNeedsSpaceForAttribute;
                endNeedsSpaceForSelfClosingTag |= this.needsSpaceSelfClosingTag;
                this.needsSpaceSelfClosingTag = startNeedsSpaceForSelfClosingTag;
            }
            this.needsSpaceForAttribute = endNeedsSpaceForAttribute;
            this.needsSpaceSelfClosingTag = endNeedsSpaceForSelfClosingTag;
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }

        @Override
        protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
            this.doVisitChildren(node);
        }

        private <C extends SoyNode> void doVisitChildren(SoyNode.ParentSoyNode<C> parent) {
            for (int i = 0; i < parent.numChildren(); ++i) {
                SoyNode child = (SoyNode)parent.getChild(i);
                this.visit(child);
                if (!this.replacements.isPresent()) continue;
                parent.removeChild(i);
                List typedReplacements = (List)this.replacements.get();
                parent.addChildren(i, typedReplacements);
                i += this.replacements.get().size() - 1;
                this.replacements = Optional.empty();
            }
            Preconditions.checkState((!this.replacements.isPresent() ? 1 : 0) != 0);
        }
    }
}

