/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.CompilerPass;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateRegistry;

final class CompilerFilePassToFileSetPassShim
implements CompilerFileSetPass {
    private final CompilerFilePass filePassDelegate;

    static CompilerFilePassToFileSetPassShim filePassAsFileSetPass(CompilerFilePass filePass) {
        return new CompilerFilePassToFileSetPassShim(filePass);
    }

    CompilerFilePassToFileSetPassShim(CompilerFilePass filePassDelegate) {
        this.filePassDelegate = filePassDelegate;
    }

    @Override
    public ImmutableList<Class<? extends CompilerPass>> runBefore() {
        return this.filePassDelegate.runBefore();
    }

    @Override
    public ImmutableList<Class<? extends CompilerPass>> runAfter() {
        return this.filePassDelegate.runAfter();
    }

    @Override
    public String name() {
        return this.filePassDelegate.name();
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator, TemplateRegistry registry) {
        for (SoyFileNode file : sourceFiles) {
            this.filePassDelegate.run(file, idGenerator);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    public Class<? extends CompilerFilePass> getDelegateClass() {
        return this.filePassDelegate.getClass();
    }

    @VisibleForTesting
    public CompilerFilePass getDelegate() {
        return this.filePassDelegate;
    }
}

