/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.Visibility;

final class CheckTemplateVisibilityPass
implements CompilerFileSetPass {
    private static final SoyErrorKind CALLEE_NOT_VISIBLE = SoyErrorKind.of("{0} has {1} access in {2}.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    CheckTemplateVisibilityPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        for (SoyFileNode file : sourceFiles) {
            for (TemplateLiteralNode node : SoyTreeUtils.getAllNodesOfType(file, TemplateLiteralNode.class)) {
                String calleeName = node.getResolvedName();
                TemplateMetadata definition = file.getTemplateRegistry().getBasicTemplateOrElement(calleeName);
                if (definition == null || CheckTemplateVisibilityPass.isVisible(file, definition)) continue;
                this.errorReporter.report(node.getSourceLocation(), CALLEE_NOT_VISIBLE, calleeName, definition.getVisibility().getAttributeValue(), definition.getSourceLocation().getFilePath());
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private static boolean isVisible(SoyFileNode calledFrom, TemplateMetadata callee) {
        return callee.getVisibility() != Visibility.PRIVATE || callee.getSourceLocation().getFilePath().equals(calledFrom.getFilePath());
    }
}

