/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.IndirectParamsCalculator;
import com.google.template.soy.passes.RuntimeTypeCoercion;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class CheckTemplateCallsPass
implements CompilerFileSetPass {
    static final SoyErrorKind ARGUMENT_TYPE_MISMATCH = SoyErrorKind.of("Type mismatch on param {0}: expected: {1}, actual: {2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind DUPLICATE_PARAM = SoyErrorKind.of("Duplicate param ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PASSES_UNUSED_PARAM = SoyErrorKind.of("''{0}'' is not a declared parameter of {1} or any indirect callee.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind MISSING_PARAM = SoyErrorKind.of("Call missing required {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PASSING_PROTOBUF_FROM_STRICT_TO_NON_STRICT = SoyErrorKind.of("Passing protobuf {0} of type {1} to an untyped template is not allowed.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STRICT_HTML = SoyErrorKind.of("Found call to non stricthtml template. Strict HTML template can only call other strict HTML templates from an HTML context.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CAN_ONLY_CALL_TEMPLATE_TYPES = SoyErrorKind.of("'{'call'}' is only valid on template types, but found type ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CANNOT_CALL_MIXED_CONTENT_TYPE = SoyErrorKind.of("Cannot call expressions of different content types; found {0} and {1}.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    CheckTemplateCallsPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        for (SoyFileNode file : sourceFiles) {
            CheckCallsHelper helper = new CheckCallsHelper(file.getTemplateRegistry());
            for (TemplateNode template : file.getTemplates()) {
                for (CallNode callNode : SoyTreeUtils.getAllNodesOfType(template, CallBasicNode.class)) {
                    helper.checkCall(template, (CallBasicNode)callNode);
                }
                for (CallNode callNode : SoyTreeUtils.getAllNodesOfType(template, CallDelegateNode.class)) {
                    helper.checkCall(template, (CallDelegateNode)callNode);
                }
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private final class CheckCallsHelper {
        private final TemplateRegistry templateRegistry;
        private final Map<TemplateType, TemplateParamTypes> paramTypesMap = new HashMap<TemplateType, TemplateParamTypes>();

        CheckCallsHelper(TemplateRegistry registry) {
            this.templateRegistry = registry;
        }

        void checkCall(TemplateNode callerTemplate, CallBasicNode node) {
            SoyType calleeType = node.getCalleeExpr().getType();
            if (calleeType.getKind() == SoyType.Kind.TEMPLATE) {
                com.google.common.base.Predicate<String> paramsToRuntimeCheck = this.checkCall(callerTemplate, node, (TemplateType)calleeType);
                node.setParamsToRuntimeCheck((Predicate<String>)paramsToRuntimeCheck);
            } else if (calleeType.getKind() == SoyType.Kind.UNION) {
                ArrayList<com.google.common.base.Predicate<String>> paramsToRuntimeCheckList = new ArrayList<com.google.common.base.Predicate<String>>();
                SanitizedContentKind sanitizedContentKind = null;
                for (SoyType member : ((UnionType)calleeType).getMembers()) {
                    if (member.getKind() == SoyType.Kind.TEMPLATE) {
                        TemplateType templateType = (TemplateType)member;
                        if (sanitizedContentKind == null) {
                            sanitizedContentKind = templateType.getContentKind();
                        } else if (templateType.getContentKind() != sanitizedContentKind) {
                            CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), CANNOT_CALL_MIXED_CONTENT_TYPE, new Object[]{sanitizedContentKind, templateType.getContentKind()});
                        }
                        paramsToRuntimeCheckList.add(this.checkCall(callerTemplate, node, templateType));
                        continue;
                    }
                    CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), CAN_ONLY_CALL_TEMPLATE_TYPES, calleeType);
                }
                node.setParamsToRuntimeCheck((Predicate<String>)Predicates.or(paramsToRuntimeCheckList));
            } else if (calleeType.getKind() != SoyType.Kind.UNKNOWN) {
                CheckTemplateCallsPass.this.errorReporter.report(node.getSourceLocation(), CAN_ONLY_CALL_TEMPLATE_TYPES, calleeType);
            }
        }

        com.google.common.base.Predicate<String> checkCall(TemplateNode callerTemplate, CallBasicNode node, TemplateType calleeType) {
            this.checkCallParamNames(node, calleeType);
            this.checkPassesUnusedParams(node, calleeType);
            this.checkStrictHtml(callerTemplate, node, calleeType);
            return this.checkCallParamTypes(callerTemplate, node, calleeType);
        }

        void checkCall(TemplateNode callerTemplate, CallDelegateNode node) {
            ImmutableMap.Builder paramsToCheckByTemplate = ImmutableMap.builder();
            ImmutableList potentialCallees = this.templateRegistry.getDelTemplateSelector().delTemplateNameToValues().get((Object)node.getDelCalleeName());
            for (TemplateMetadata delTemplate : potentialCallees) {
                TemplateType delTemplateType = TemplateMetadata.asTemplateType(delTemplate);
                com.google.common.base.Predicate<String> params = this.checkCallParamTypes(callerTemplate, node, delTemplateType);
                paramsToCheckByTemplate.put((Object)delTemplate.getTemplateName(), params);
                this.checkCallParamNames(node, delTemplateType);
            }
            node.setParamsToRuntimeCheck((ImmutableMap<String, Predicate<String>>)paramsToCheckByTemplate.build());
            if (!potentialCallees.isEmpty()) {
                this.checkStrictHtml(callerTemplate, node, TemplateMetadata.asTemplateType((TemplateMetadata)potentialCallees.get(0)));
            }
        }

        private com.google.common.base.Predicate<String> checkCallParamTypes(TemplateNode callerTemplate, CallNode call, TemplateType callee) {
            Collection declaredParamTypes;
            String paramName;
            TemplateParamTypes calleeParamTypes = this.getTemplateParamTypes(callee);
            HashSet<String> explicitParams = new HashSet<String>();
            HashSet paramNamesToRuntimeCheck = new HashSet(calleeParamTypes.params.keySet());
            paramNamesToRuntimeCheck.removeAll(calleeParamTypes.indirectParamNames);
            for (Object callerParam : call.getChildren()) {
                paramName = ((CallParamNode)callerParam).getKey().identifier();
                declaredParamTypes = calleeParamTypes.params.get((Object)paramName);
                SoyType argType = null;
                if (callerParam.getKind() == SoyNode.Kind.CALL_PARAM_VALUE_NODE) {
                    CallParamValueNode node = (CallParamValueNode)callerParam;
                    ExprRootNode expr = node.getExpr();
                    if (expr != null) {
                        argType = RuntimeTypeCoercion.maybeCoerceType(node.getExpr().getRoot(), declaredParamTypes);
                    }
                } else if (callerParam.getKind() == SoyNode.Kind.CALL_PARAM_CONTENT_NODE) {
                    SanitizedContentKind contentKind = ((CallParamContentNode)callerParam).getContentKind();
                    argType = contentKind == null ? StringType.getInstance() : SanitizedType.getTypeForContentKind(contentKind);
                } else {
                    throw new AssertionError();
                }
                if (argType != null && argType.getKind() != SoyType.Kind.ERROR) {
                    boolean staticTypeSafe = true;
                    for (SoyType formalType : declaredParamTypes) {
                        staticTypeSafe &= this.checkArgumentAgainstParamType(((AbstractSoyNode)callerParam).getSourceLocation(), paramName, argType, formalType, calleeParamTypes);
                    }
                    if (staticTypeSafe) {
                        paramNamesToRuntimeCheck.remove(paramName);
                    }
                }
                explicitParams.add(paramName);
            }
            if (call.isPassingData() && call.isPassingAllData()) {
                for (Object callerParam : callerTemplate.getParams()) {
                    paramName = ((AbstractVarDefn)callerParam).name();
                    if (explicitParams.contains(paramName)) continue;
                    declaredParamTypes = calleeParamTypes.params.get((Object)paramName);
                    boolean staticTypeSafe = true;
                    for (SoyType formalType : declaredParamTypes) {
                        staticTypeSafe &= this.checkArgumentAgainstParamType(call.getSourceLocation(), paramName, ((AbstractVarDefn)callerParam).type(), formalType, calleeParamTypes);
                    }
                    if (!staticTypeSafe) continue;
                    paramNamesToRuntimeCheck.remove(paramName);
                }
            }
            return arg_0 -> ((ImmutableSet)ImmutableSet.copyOf(paramNamesToRuntimeCheck)).contains(arg_0);
        }

        private boolean checkArgumentAgainstParamType(SourceLocation location, String paramName, SoyType argType, SoyType formalType, TemplateParamTypes calleeParams) {
            if (formalType.getKind() == SoyType.Kind.ANY) {
                if (argType.getKind() == SoyType.Kind.PROTO) {
                    CheckTemplateCallsPass.this.errorReporter.report(location, PASSING_PROTOBUF_FROM_STRICT_TO_NON_STRICT, paramName, argType);
                }
            } else if (!(argType.getKind() == SoyType.Kind.UNKNOWN && SoyTypes.tryRemoveNull(formalType).getKind() != SoyType.Kind.MAP && SoyTypes.tryRemoveNull(formalType).getKind() != SoyType.Kind.VE && SoyTypes.tryRemoveNull(formalType).getKind() != SoyType.Kind.VE_DATA || formalType.isAssignableFrom(argType))) {
                if (calleeParams.isIndirect(paramName) && argType.getKind() == SoyType.Kind.UNION && ((UnionType)argType).isNullable() && SoyTypes.makeNullable(formalType).isAssignableFrom(argType)) {
                    return false;
                }
                CheckTemplateCallsPass.this.errorReporter.report(location, ARGUMENT_TYPE_MISMATCH, paramName, formalType, argType);
            }
            return true;
        }

        private TemplateParamTypes getTemplateParamTypes(TemplateType callee) {
            TemplateParamTypes paramTypes = this.paramTypesMap.get(callee);
            if (paramTypes == null) {
                paramTypes = new TemplateParamTypes();
                for (TemplateType.Parameter param : callee.getParameters()) {
                    paramTypes.params.put((Object)param.getName(), (Object)param.getType());
                }
                IndirectParamsCalculator.IndirectParamsInfo ipi = new IndirectParamsCalculator(this.templateRegistry).calculateIndirectParams(callee);
                for (String indirectParamName : ipi.indirectParamTypes.keySet()) {
                    if (paramTypes.params.containsKey((Object)indirectParamName)) continue;
                    paramTypes.params.putAll((Object)indirectParamName, (Iterable)ipi.indirectParamTypes.get((Object)indirectParamName));
                    paramTypes.indirectParamNames.add(indirectParamName);
                }
                this.paramTypesMap.put(callee, paramTypes);
            }
            return paramTypes;
        }

        private void checkStrictHtml(TemplateNode callerTemplate, CallNode caller, @Nullable TemplateType callee) {
            if (callerTemplate.isStrictHtml() && caller.getIsPcData() && callee != null && callee.getContentKind() == SanitizedContentKind.HTML && !callee.isStrictHtml()) {
                CheckTemplateCallsPass.this.errorReporter.report(caller.getSourceLocation(), STRICT_HTML, new Object[0]);
            }
        }

        private void checkCallParamNames(CallNode caller, TemplateType callee) {
            if (callee != null) {
                HashSet callerParamKeys = Sets.newHashSet();
                for (CallParamNode callerParam : caller.getChildren()) {
                    boolean isUnique = callerParamKeys.add(callerParam.getKey().identifier());
                    if (isUnique) continue;
                    CheckTemplateCallsPass.this.errorReporter.report(callerParam.getKey().location(), DUPLICATE_PARAM, callerParam.getKey().identifier());
                }
                if (!caller.isPassingData()) {
                    ArrayList missingParamKeys = Lists.newArrayListWithCapacity((int)2);
                    for (TemplateType.Parameter calleeParam : callee.getParameters()) {
                        if (!calleeParam.isRequired() || callerParamKeys.contains(calleeParam.getName())) continue;
                        missingParamKeys.add(calleeParam.getName());
                    }
                    if (!missingParamKeys.isEmpty()) {
                        String errorMsgEnd = missingParamKeys.size() == 1 ? "param '" + (String)missingParamKeys.get(0) + "'" : "params " + missingParamKeys;
                        CheckTemplateCallsPass.this.errorReporter.report(caller.getSourceLocation(), MISSING_PARAM, errorMsgEnd);
                    }
                }
            }
        }

        private void checkPassesUnusedParams(CallNode caller, TemplateType callee) {
            if (caller.numChildren() == 0) {
                return;
            }
            HashSet paramNames = Sets.newHashSet();
            for (TemplateType.Parameter param : callee.getParameters()) {
                paramNames.add(param.getName());
            }
            IndirectParamsCalculator.IndirectParamsInfo ipi = null;
            for (CallParamNode callerParam : caller.getChildren()) {
                String paramName = callerParam.getKey().identifier();
                if (paramNames.contains(paramName)) continue;
                if (ipi == null) {
                    ipi = new IndirectParamsCalculator(this.templateRegistry).calculateIndirectParams(callee);
                    if (ipi.mayHaveIndirectParamsInExternalCalls || ipi.mayHaveIndirectParamsInExternalDelCalls) {
                        return;
                    }
                }
                if (ipi.indirectParams.containsKey((Object)paramName)) continue;
                ImmutableSet allParams = ImmutableSet.builder().addAll((Iterable)paramNames).addAll((Iterable)ipi.indirectParams.keySet()).build();
                CheckTemplateCallsPass.this.errorReporter.report(callerParam.getKey().location(), PASSES_UNUSED_PARAM, paramName, callee.getIdentifierForDebugging(), SoyErrors.getDidYouMeanMessage((Iterable<String>)allParams, paramName));
            }
        }

        private class TemplateParamTypes {
            public final Multimap<String, SoyType> params = HashMultimap.create();
            public final Set<String> indirectParamNames = new HashSet<String>();

            private TemplateParamTypes() {
            }

            public boolean isIndirect(String paramName) {
                return this.indirectParamNames.contains(paramName);
            }
        }
    }
}

