/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;

final class CheckNoNamedTemplateTypesPass
implements CompilerFileSetPass {
    CheckNoNamedTemplateTypesPass() {
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator, TemplateRegistry registry) {
        for (SoyFileNode file : sourceFiles) {
            for (ExprNode exprNode : SoyTreeUtils.getAllNodesOfType(file, ExprNode.class)) {
                if (!SoyTypes.transitivelyContainsKind(exprNode.getType(), SoyType.Kind.NAMED_TEMPLATE)) continue;
                throw new IllegalStateException("Found non-upgraded Named Template type after they should have all been removed. This is most likely a parsing error; please file a go/soy-bug. Problem expression: " + exprNode + " at " + exprNode.getSourceLocation());
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }
}

