/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.shared.internal.DelTemplateSelector;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class CheckDelegatesPass
implements CompilerFileSetPass {
    private static final SoyErrorKind CALL_TO_DELTEMPLATE = SoyErrorKind.of("''call'' to delegate template ''{0}'' (expected ''delcall'').", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DELTEMPLATE_IN_EXPRESSION = SoyErrorKind.of("Delegate template `{0}` not allowed in expression; only basic templates may be used in expressions.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CROSS_PACKAGE_DELCALL = SoyErrorKind.of("Found illegal call from ''{0}'' to ''{1}'', which is in a different delegate package.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DELCALL_TO_BASIC_TEMPLATE = SoyErrorKind.of("''delcall'' to basic template ''{0}'' (expected ''call'').", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DELTEMPLATES_WITH_DIFFERENT_PARAM_DECLARATIONS = SoyErrorKind.of("Found delegate template with same name ''{0}'' but different param declarations compared to the definition at {1}.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind STRICT_DELTEMPLATES_WITH_DIFFERENT_CONTENT_KIND = SoyErrorKind.of("If one deltemplate has strict autoescaping, all its peers must also be strictly autoescaped with the same content kind: {0} != {1}. Conflicting definition at {2}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DELTEMPLATES_WITH_DIFFERENT_STRICT_HTML_MODE = SoyErrorKind.of("Found delegate template with same name ''{0}'' but different strict html mode compared to the definition at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    CheckDelegatesPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator, TemplateRegistry fileSetTemplateRegistry) {
        this.checkTemplates(fileSetTemplateRegistry.getDelTemplateSelector());
        for (SoyFileNode fileNode : sourceFiles) {
            for (TemplateNode template : fileNode.getTemplates()) {
                String currTemplateNameForUserMsgs = template.getTemplateNameForUserMsgs();
                String currDelPackageName = template.getDelPackageName();
                for (TemplateLiteralNode templateLiteralNode : SoyTreeUtils.getAllNodesOfType(template, TemplateLiteralNode.class)) {
                    this.checkTemplateLiteralNode(templateLiteralNode, fileNode.getTemplateRegistry(), currDelPackageName, currTemplateNameForUserMsgs);
                }
                for (CallDelegateNode callNode : SoyTreeUtils.getAllNodesOfType(template, CallDelegateNode.class)) {
                    this.checkCallDelegateNode(callNode, fileNode.getTemplateRegistry());
                }
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void checkTemplates(DelTemplateSelector<TemplateMetadata> fileSetDelTemplateSelector) {
        for (Collection delTemplateGroup : fileSetDelTemplateSelector.delTemplateNameToValues().asMap().values()) {
            TemplateMetadata firstDelTemplate = null;
            for (TemplateMetadata delTemplate : delTemplateGroup) {
                if (firstDelTemplate == null) {
                    firstDelTemplate = delTemplate;
                }
                if (delTemplate.getSoyFileKind() != SoyFileKind.SRC) continue;
                firstDelTemplate = delTemplate;
                break;
            }
            if (firstDelTemplate == null) continue;
            Set<TemplateMetadata.Parameter> firstRequiredParamSet = CheckDelegatesPass.getRequiredParamSet(firstDelTemplate);
            SanitizedContentKind firstContentKind = firstDelTemplate.getContentKind();
            boolean firstStrictHtml = firstDelTemplate.isStrictHtml() && firstContentKind == SanitizedContentKind.HTML;
            for (TemplateMetadata delTemplate : delTemplateGroup) {
                if (firstDelTemplate == delTemplate) continue;
                Set<TemplateMetadata.Parameter> currRequiredParamSet = CheckDelegatesPass.getRequiredParamSet(delTemplate);
                if (!CheckDelegatesPass.paramSetsEqual(currRequiredParamSet, firstRequiredParamSet)) {
                    ImmutableList<TemplateMetadata.Parameter> firstParamList = firstDelTemplate.getParameters();
                    ImmutableList<TemplateMetadata.Parameter> currParamList = delTemplate.getParameters();
                    Set<TemplateMetadata.Parameter> missingParamSet = CheckDelegatesPass.getRequiredParamsDifference(firstParamList, currParamList);
                    Set<TemplateMetadata.Parameter> unexpectedParamSet = CheckDelegatesPass.getRequiredParamsDifference(currParamList, firstParamList);
                    this.errorReporter.report(delTemplate.getSourceLocation(), DELTEMPLATES_WITH_DIFFERENT_PARAM_DECLARATIONS, delTemplate.getDelTemplateName(), firstDelTemplate.getSourceLocation().toString(), CheckDelegatesPass.getInconsistentParamMessage(missingParamSet, unexpectedParamSet));
                }
                if (delTemplate.getContentKind() != firstContentKind) {
                    this.errorReporter.report(firstDelTemplate.getSourceLocation(), STRICT_DELTEMPLATES_WITH_DIFFERENT_CONTENT_KIND, String.valueOf((Object)delTemplate.getContentKind()), String.valueOf((Object)firstContentKind), delTemplate.getSourceLocation().toString());
                }
                if (delTemplate.isStrictHtml() == firstStrictHtml) continue;
                this.errorReporter.report(firstDelTemplate.getSourceLocation(), DELTEMPLATES_WITH_DIFFERENT_STRICT_HTML_MODE, delTemplate.getDelTemplateName(), delTemplate.getSourceLocation().toString());
            }
        }
    }

    private static boolean paramSetsEqual(Set<TemplateMetadata.Parameter> s1, Set<TemplateMetadata.Parameter> s2) {
        return s1.equals(s2);
    }

    private static Set<TemplateMetadata.Parameter> getRequiredParamSet(TemplateMetadata delTemplate) {
        return delTemplate.getParameters().stream().filter(TemplateMetadata.Parameter::isRequired).map(TemplateMetadata.Parameter::toComparable).collect(Collectors.toSet());
    }

    private void checkTemplateLiteralNode(TemplateLiteralNode node, TemplateRegistry templateRegistry, @Nullable String currDelPackageName, String currTemplateNameForUserMsgs) {
        String calleeDelPackageName;
        TemplateMetadata callee;
        String calleeName = node.getResolvedName();
        if (templateRegistry.getDelTemplateSelector().hasDelTemplateNamed(calleeName)) {
            if (node.isSynthetic()) {
                this.errorReporter.report(node.getSourceLocation(), CALL_TO_DELTEMPLATE, calleeName);
            } else {
                this.errorReporter.report(node.getSourceLocation(), DELTEMPLATE_IN_EXPRESSION, calleeName);
            }
        }
        if ((callee = templateRegistry.getBasicTemplateOrElement(calleeName)) != null && (calleeDelPackageName = callee.getDelPackageName()) != null && !calleeDelPackageName.equals(currDelPackageName)) {
            if (node.getNearestAncestor(CallParamContentNode.class) == null) {
                this.errorReporter.report(node.getSourceLocation(), CROSS_PACKAGE_DELCALL, currTemplateNameForUserMsgs, callee.getTemplateName());
            } else {
                this.errorReporter.warn(node.getSourceLocation(), CROSS_PACKAGE_DELCALL, currTemplateNameForUserMsgs, callee.getTemplateName());
            }
        }
    }

    private void checkCallDelegateNode(CallDelegateNode node, TemplateRegistry templateRegistry) {
        String delCalleeName = node.getDelCalleeName();
        if (templateRegistry.getBasicTemplateOrElement(delCalleeName) != null) {
            this.errorReporter.report(node.getSourceLocation(), DELCALL_TO_BASIC_TEMPLATE, delCalleeName);
        }
    }

    private static String getInconsistentParamMessage(Set<TemplateMetadata.Parameter> missingParamSet, Set<TemplateMetadata.Parameter> unexpectedParamSet) {
        StringBuilder message = new StringBuilder();
        if (!missingParamSet.isEmpty()) {
            message.append(String.format("\n  Missing params: %s", CheckDelegatesPass.formatParamSet(missingParamSet)));
        }
        if (!unexpectedParamSet.isEmpty()) {
            message.append(String.format("\n  Unexpected params: %s", CheckDelegatesPass.formatParamSet(unexpectedParamSet)));
        }
        return message.toString();
    }

    private static Set<String> formatParamSet(Set<TemplateMetadata.Parameter> paramSet) {
        return paramSet.stream().map(param -> {
            String formattedParam = param.getName() + ": " + param.getType();
            formattedParam = formattedParam + (param.isRequired() ? "" : " (optional)");
            return formattedParam;
        }).collect(Collectors.toSet());
    }

    private static Set<TemplateMetadata.Parameter> getRequiredParamsDifference(List<TemplateMetadata.Parameter> paramList1, List<TemplateMetadata.Parameter> paramList2) {
        Map nameToParamMap = (Map)paramList2.stream().map(TemplateMetadata.Parameter::toComparable).collect(ImmutableMap.toImmutableMap(TemplateMetadata.Parameter::getName, param -> param));
        return paramList1.stream().filter(param -> {
            String paramName = param.getName();
            if (!nameToParamMap.containsKey(paramName)) {
                return param.isRequired();
            }
            TemplateMetadata.Parameter param2 = (TemplateMetadata.Parameter)nameToParamMap.get(paramName);
            return !param.equals(param2) && (param.isRequired() || param2.isRequired());
        }).collect(Collectors.toSet());
    }
}

