/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.InferenceEngine;
import com.google.template.soy.parsepasses.contextautoesc.Inferences;
import com.google.template.soy.parsepasses.contextautoesc.Rewriter;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeException;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;

public final class ContextualAutoescaper {
    @VisibleForTesting
    static final String AUTOESCAPE_ERROR_PREFIX = "Invalid or ambiguous syntax prevents Soy from escaping this template correctly:\n";
    private static final SoyErrorKind AUTOESCAPE_ERROR = SoyErrorKind.of("Invalid or ambiguous syntax prevents Soy from escaping this template correctly:\n{0}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ErrorReporter errorReporter;
    private final ImmutableList<? extends SoyPrintDirective> printDirectives;

    public ContextualAutoescaper(ErrorReporter errorReporter, ImmutableList<? extends SoyPrintDirective> soyDirectives) {
        this.errorReporter = errorReporter;
        this.printDirectives = soyDirectives;
    }

    public Inferences annotate(ImmutableList<SoyFileNode> sourceFiles) {
        Inferences inferences = new Inferences();
        for (SoyFileNode file : sourceFiles) {
            inferences.setTemplateRegistry(file.hasTemplateRegistry() ? file.getTemplateRegistry() : TemplateRegistry.EMPTY);
            for (TemplateNode templateNode : file.getTemplates()) {
                try {
                    Context startContext = Context.getStartContextForContentKind(templateNode.getContentKind());
                    InferenceEngine.inferTemplateEndContext(templateNode, startContext, inferences, this.errorReporter);
                }
                catch (SoyAutoescapeException e) {
                    this.reportError(this.errorReporter, e);
                }
            }
        }
        if (this.errorReporter.hasErrors()) {
            return null;
        }
        return inferences;
    }

    public void rewrite(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator, Inferences inferences) {
        Rewriter rewriter = new Rewriter(inferences, idGenerator, this.printDirectives);
        for (SoyFileNode file : sourceFiles) {
            rewriter.rewrite(file);
        }
    }

    private void reportError(ErrorReporter errorReporter, SoyAutoescapeException e) {
        String message = "- " + e.getOriginalMessage();
        while (e.getCause() instanceof SoyAutoescapeException) {
            e = (SoyAutoescapeException)e.getCause();
            message = message + "\n- " + e.getMessage();
        }
        errorReporter.report(e.getSourceLocation(), AUTOESCAPE_ERROR, message);
    }
}

