/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@Immutable
public class SoyMsgBundleImpl
extends SoyMsgBundle {
    private final String localeString;
    private final ULocale locale;
    private final boolean isRtl;
    private final ImmutableMap<Long, SoyMsg> msgMap;
    private static final Pattern MESSAGE_ATTRIBUTE_PATTERN = Pattern.compile("\\[[^\\[\\]]*\\]");

    public SoyMsgBundleImpl(@Nullable String localeString, List<SoyMsg> msgs) {
        this.localeString = localeString;
        this.locale = localeString == null ? null : new ULocale(localeString);
        this.isRtl = BidiGlobalDir.forStaticLocale(localeString) == BidiGlobalDir.RTL;
        LinkedHashMap<Long, SoyMsg> tempMsgMap = new LinkedHashMap<Long, SoyMsg>();
        for (SoyMsg msg : msgs) {
            Preconditions.checkArgument((boolean)Objects.equals(msg.getLocaleString(), localeString));
            long msgId = msg.getId();
            SoyMsg existingMsg = (SoyMsg)tempMsgMap.get(msgId);
            if (existingMsg == null) {
                tempMsgMap.put(msgId, msg);
                continue;
            }
            SoyMsg.Builder mergedMessage = existingMsg.toBuilder().setHasFallback(existingMsg.hasFallback() && msg.hasFallback()).setDesc(existingMsg.getDesc() + this.extractAttributes(msg)).addAllSourceLocations((Iterable<SoyMsg.SourceLocationAndTemplate>)msg.getSourceLocations());
            tempMsgMap.put(msgId, mergedMessage.build());
        }
        this.msgMap = ImmutableMap.copyOf(tempMsgMap);
    }

    private String extractAttributes(SoyMsg msg) {
        StringBuilder attributes = new StringBuilder();
        Matcher matcher = MESSAGE_ATTRIBUTE_PATTERN.matcher(msg.getDesc());
        while (matcher.find()) {
            attributes.append(matcher.group());
        }
        return attributes.toString();
    }

    @Override
    public String getLocaleString() {
        return this.localeString;
    }

    @Override
    @Nullable
    public ULocale getLocale() {
        return this.locale;
    }

    @Override
    public boolean isRtl() {
        return this.isRtl;
    }

    @Override
    public SoyMsg getMsg(long msgId) {
        return (SoyMsg)this.msgMap.get((Object)msgId);
    }

    @Override
    public int getNumMsgs() {
        return this.msgMap.size();
    }

    @Override
    public Iterator<SoyMsg> iterator() {
        return this.msgMap.values().iterator();
    }
}

