/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.CompactInterner;
import com.google.template.soy.msgs.restricted.MsgPartUtils;
import com.google.template.soy.msgs.restricted.RenderOnlySoyMsgBundleImpl;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralCaseSpec;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import java.util.Objects;

public final class SoyMsgBundleCompactor {
    private static final SoyMsgPluralCaseSpec DEFAULT_PLURAL_CASE_SPEC = new SoyMsgPluralCaseSpec(SoyMsgPluralCaseSpec.Type.OTHER);
    private static final String DEFAULT_SELECT_CASE_SPEC = null;
    private final CompactInterner interner = new CompactInterner();

    public SoyMsgBundle compact(SoyMsgBundle input) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SoyMsg msg : input) {
            ImmutableList<SoyMsgPart> parts = this.compactParts(msg.getParts());
            builder.add((Object)SoyMsg.builder().setId(msg.getId()).setLocaleString(msg.getLocaleString()).setIsPlrselMsg(MsgPartUtils.hasPlrselPart(parts)).setParts((Iterable<? extends SoyMsgPart>)parts).build());
        }
        return new RenderOnlySoyMsgBundleImpl(input.getLocaleString(), (Iterable<SoyMsg>)builder.build());
    }

    private ImmutableList<SoyMsgPart> compactParts(ImmutableList<SoyMsgPart> parts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SoyMsgPart part : parts) {
            builder.add((Object)this.compactPart(part));
        }
        return builder.build();
    }

    private SoyMsgPart compactPart(SoyMsgPart part) {
        if (part instanceof SoyMsgPluralPart) {
            part = this.compactPlural((SoyMsgPluralPart)part);
        } else if (part instanceof SoyMsgSelectPart) {
            part = this.compactSelect((SoyMsgSelectPart)part);
        } else if (part instanceof SoyMsgPlaceholderPart) {
            part = this.compactPlaceholder((SoyMsgPlaceholderPart)part);
        }
        return this.intern(part);
    }

    private SoyMsgPart compactPlaceholder(SoyMsgPlaceholderPart part) {
        return new SoyMsgPlaceholderPart(this.intern(part.getPlaceholderName()));
    }

    private SoyMsgPart compactSelect(SoyMsgSelectPart select) {
        return new SoyMsgSelectPart(this.intern(select.getSelectVarName()), (Iterable<SoyMsgPart.Case<String>>)this.compactCases(select.getCases(), DEFAULT_SELECT_CASE_SPEC));
    }

    private SoyMsgPart compactPlural(SoyMsgPluralPart plural) {
        return new SoyMsgPluralPart(this.intern(plural.getPluralVarName()), plural.getOffset(), (Iterable<SoyMsgPart.Case<SoyMsgPluralCaseSpec>>)this.compactCases(plural.getCases(), DEFAULT_PLURAL_CASE_SPEC));
    }

    private <T> ImmutableList<SoyMsgPart.Case<T>> compactCases(ImmutableList<SoyMsgPart.Case<T>> cases, T defaultCaseSpec) {
        ImmutableList<SoyMsgPart> defaultValue = null;
        for (SoyMsgPart.Case caseAndValue : cases) {
            if (!Objects.equals(caseAndValue.spec(), defaultCaseSpec)) continue;
            defaultValue = caseAndValue.parts();
            break;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SoyMsgPart.Case caseAndValue : cases) {
            if (defaultValue != null && !Objects.equals(caseAndValue.spec(), defaultCaseSpec) && defaultValue.equals(caseAndValue.parts())) continue;
            builder.add(SoyMsgPart.Case.create(caseAndValue.spec() != null ? (Object)this.intern(caseAndValue.spec()) : null, this.compactParts(caseAndValue.parts())));
        }
        return builder.build();
    }

    private <T> T intern(T input) {
        return this.interner.intern(input);
    }
}

