/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.ImmutableLongArray;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.MsgPartUtils;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;

@Immutable
final class RenderOnlySoyMsgBundleImpl
extends SoyMsgBundle {
    private final String localeString;
    private final ULocale locale;
    private final boolean isRtl;
    private final ImmutableLongArray ids;
    private final ImmutableList<ImmutableList<SoyMsgPart>> values;

    public RenderOnlySoyMsgBundleImpl(@Nullable String localeString, Iterable<SoyMsg> msgs) {
        this.localeString = localeString;
        this.locale = localeString == null ? null : new ULocale(localeString);
        this.isRtl = BidiGlobalDir.forStaticLocale(localeString) == BidiGlobalDir.RTL;
        TreeMap<Long, ImmutableList<SoyMsgPart>> partsMap = new TreeMap<Long, ImmutableList<SoyMsgPart>>();
        for (SoyMsg msg : msgs) {
            Preconditions.checkArgument((boolean)Objects.equals(msg.getLocaleString(), localeString));
            long msgId = msg.getId();
            Preconditions.checkArgument((!partsMap.containsKey(msgId) ? 1 : 0) != 0, (Object)"Duplicate messages are not permitted in the render-only impl.");
            ImmutableList<SoyMsgPart> parts = msg.getParts();
            Preconditions.checkArgument((MsgPartUtils.hasPlrselPart(parts) == msg.isPlrselMsg() ? 1 : 0) != 0, (Object)"Message's plural/select status is inconsistent -- internal compiler bug.");
            partsMap.put(msgId, parts);
        }
        this.ids = ImmutableLongArray.copyOf(partsMap.keySet());
        this.values = ImmutableList.copyOf(partsMap.values());
    }

    private SoyMsg resurrectMsg(long id, ImmutableList<SoyMsgPart> parts) {
        return SoyMsg.builder().setId(id).setLocaleString(this.localeString).setIsPlrselMsg(MsgPartUtils.hasPlrselPart(parts)).setParts((Iterable<? extends SoyMsgPart>)parts).build();
    }

    @Override
    public String getLocaleString() {
        return this.localeString;
    }

    @Override
    @Nullable
    public ULocale getLocale() {
        return this.locale;
    }

    @Override
    public boolean isRtl() {
        return this.isRtl;
    }

    @Override
    public SoyMsg getMsg(long msgId) {
        int index = this.binarySearch(msgId);
        return index >= 0 ? this.resurrectMsg(msgId, (ImmutableList<SoyMsgPart>)((ImmutableList)this.values.get(index))) : null;
    }

    @Override
    public ImmutableList<SoyMsgPart> getMsgParts(long msgId) {
        int index = this.binarySearch(msgId);
        return index >= 0 ? (ImmutableList)this.values.get(index) : ImmutableList.of();
    }

    private int binarySearch(long key) {
        int low = 0;
        int high = this.ids.length() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this.ids.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public int getNumMsgs() {
        return this.ids.length();
    }

    @Override
    public Iterator<SoyMsg> iterator() {
        return new Iterator<SoyMsg>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < RenderOnlySoyMsgBundleImpl.this.ids.length();
            }

            @Override
            public SoyMsg next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                SoyMsg result = RenderOnlySoyMsgBundleImpl.this.resurrectMsg(RenderOnlySoyMsgBundleImpl.this.ids.get(this.index), (ImmutableList<SoyMsgPart>)((ImmutableList)RenderOnlySoyMsgBundleImpl.this.values.get(this.index)));
                ++this.index;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Iterator is immutable");
            }
        };
    }
}

