/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgBundleImpl;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class ExtractMsgsVisitor
extends AbstractSoyNodeVisitor<SoyMsgBundle> {
    private List<SoyMsg> msgs;
    private String currentTemplate;

    @Override
    public SoyMsgBundle exec(SoyNode node) {
        Preconditions.checkArgument((node instanceof SoyFileSetNode || node instanceof SoyFileNode ? 1 : 0) != 0);
        this.msgs = Lists.newArrayList();
        this.visit(node);
        Collections.sort(this.msgs, Comparator.comparing(m -> ((SoyMsg.SourceLocationAndTemplate)Iterables.getOnlyElement(m.getSourceLocations())).sourceLocation()));
        return new SoyMsgBundleImpl(null, this.msgs);
    }

    @Override
    protected void visitMsgNode(MsgNode node) {
        MsgUtils.MsgPartsAndIds msgPartsAndIds = MsgUtils.buildMsgPartsAndComputeMsgIdForDualFormat(node);
        SoyMsg.Builder builder = SoyMsg.builder().setId(msgPartsAndIds.id);
        if (node.getMeaning() != null) {
            builder.setMeaning(node.getMeaning());
        }
        node.getAlternateId().ifPresent(builder::setAlternateId);
        SoyMsg msg = builder.setDesc(node.getDesc()).setIsHidden(node.isHidden()).setContentType(node.getContentType()).addSourceLocation(node.getSourceLocation(), this.currentTemplate).setIsPlrselMsg(node.isPlrselMsg()).setParts((Iterable<? extends SoyMsgPart>)msgPartsAndIds.parts).setHasFallback(node.getParent().numChildren() == 2 && node.getParent().getChildIndex(node) == 0).build();
        this.msgs.add(msg);
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        if (node instanceof TemplateDelegateNode) {
            this.currentTemplate = ((TemplateDelegateNode)node).getDelTemplateName();
        }
        this.currentTemplate = node.getTemplateName();
        super.visitTemplateNode(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

