/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.logging;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import com.google.common.primitives.Bytes;
import com.google.escapevelocity.Template;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.template.soy.logging.AnnotatedLoggableElement;
import com.google.template.soy.logging.AnnotatedLoggingConfig;
import com.google.template.soy.logging.AutoValue_VeMetadataGenerator_VeMetadata;
import com.google.template.soy.logging.LoggableElementMetadata;
import com.google.template.soy.logging.VeMetadataExtensionRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;

public final class VeMetadataGenerator {
    private static final Joiner COMMA = Joiner.on((String)", ");
    private final Mode mode;
    private final ByteSource loggingConfigBytes;
    private final String generator;
    private final SoyTypeRegistry typeRegistry;

    public VeMetadataGenerator(Mode mode, ByteSource loggingConfigBytes, String generator, SoyTypeRegistry typeRegistry) {
        this.mode = mode;
        this.loggingConfigBytes = loggingConfigBytes;
        this.generator = generator;
        this.typeRegistry = typeRegistry;
    }

    public String generate() throws IOException {
        ExtensionRegistry registry = new VeMetadataExtensionRegistry(this.typeRegistry).createRegistry();
        AnnotatedLoggingConfig loggingConfig = this.parseLoggingConfig(registry);
        String javaPackage = loggingConfig.getElement(0).getJavaPackage();
        String className = loggingConfig.getElement(0).getClassName();
        ImmutableList<VeMetadata> veMetadatas = VeMetadataGenerator.getVeMetadatas(this.mode, loggingConfig, javaPackage, className, registry);
        return this.generateMetadataFile(this.mode, javaPackage, className, this.generator, veMetadatas);
    }

    private AnnotatedLoggingConfig parseLoggingConfig(ExtensionRegistry registry) throws IOException {
        try (InputStream input = this.loggingConfigBytes.openStream();){
            AnnotatedLoggingConfig annotatedLoggingConfig = AnnotatedLoggingConfig.parseFrom(input, (ExtensionRegistryLite)registry);
            return annotatedLoggingConfig;
        }
    }

    private static ImmutableList<VeMetadata> getVeMetadatas(Mode mode, AnnotatedLoggingConfig loggingConfig, String javaPackage, String className, ExtensionRegistry registry) {
        Function encodingFunction = mode.getEncodingFunction(registry);
        ImmutableList.Builder veMetadatas = ImmutableList.builder();
        for (AnnotatedLoggableElement element : loggingConfig.getElementList()) {
            Preconditions.checkState((boolean)javaPackage.equals(element.getJavaPackage()), (String)"expected %s but got %s", (Object)javaPackage, (Object)element.getJavaPackage());
            Preconditions.checkState((boolean)className.equals(element.getClassName()), (String)"expected %s but got %s", (Object)className, (Object)element.getClassName());
            if (!element.getHasMetadata()) continue;
            veMetadatas.add((Object)VeMetadata.create(element, encodingFunction));
        }
        return veMetadatas.build();
    }

    private String generateMetadataFile(Mode mode, String javaPackage, String className, String generator, ImmutableList<VeMetadata> veMetadatas) throws IOException {
        Template template = Template.parseFrom((Reader)new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(mode.getTemplateFilename()), StandardCharsets.UTF_8)));
        ImmutableMap vars = ImmutableMap.of((Object)"package", (Object)javaPackage, (Object)"className", (Object)className, (Object)"generator", (Object)generator, (Object)"veMetadatas", veMetadatas);
        return template.evaluate((Map)vars);
    }

    @AutoValue
    public static abstract class VeMetadata {
        private static VeMetadata create(AnnotatedLoggableElement element, Function<LoggableElementMetadata, String> encodingFunction) {
            return new AutoValue_VeMetadataGenerator_VeMetadata(element.getElement().getId(), encodingFunction.apply(element.getElement().getMetadata()));
        }

        public abstract long id();

        public abstract String encodedMetadata();
    }

    public static enum Mode {
        SERVER("server_ve_metadata.vm"),
        CLIENT("client_ve_metadata.vm");

        private final String templateFileName;

        private Mode(String templateFileName) {
            this.templateFileName = templateFileName;
        }

        private String getTemplateFilename() {
            return this.templateFileName;
        }

        private Function<LoggableElementMetadata, String> getEncodingFunction(ExtensionRegistry extensionRegistry) {
            switch (this) {
                case SERVER: {
                    return metadata -> COMMA.join((Iterable)Bytes.asList((byte[])metadata.toByteArray()));
                }
                case CLIENT: {
                    return metadata -> Arrays.toString(metadata.toByteArray());
                }
            }
            throw new AssertionError();
        }
    }
}

