/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.logging;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.logging.AnnotatedLoggableElement;
import com.google.template.soy.logging.AnnotatedLoggingConfig;
import com.google.template.soy.logging.AutoValue_ValidatedLoggingConfig_ValidatedLoggableElement;
import com.google.template.soy.logging.LoggableElement;
import java.util.LinkedHashMap;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ValidatedLoggingConfig {
    public static final String UNDEFINED_VE_NAME = "UndefinedVe";
    public static final AnnotatedLoggableElement UNDEFINED_VE = AnnotatedLoggableElement.newBuilder().setElement(LoggableElement.newBuilder().setName("UndefinedVe").setId(-1L).build()).build();
    public static final ValidatedLoggingConfig EMPTY = ValidatedLoggingConfig.create(AnnotatedLoggingConfig.newBuilder().addElement(UNDEFINED_VE).build());
    private static final long MAX_ID_VALUE = 0x1FFFFFFFFFFFFFL;
    private static final long MIN_ID_VALUE = -9007199254740991L;
    private final ImmutableMap<String, ValidatedLoggableElement> elementsByName;

    public static ValidatedLoggingConfig create(AnnotatedLoggingConfig configProto) {
        if (configProto.getElementCount() == 0) {
            return EMPTY;
        }
        LinkedHashMap<String, ValidatedLoggableElement> elementsByName = new LinkedHashMap<String, ValidatedLoggableElement>();
        LinkedHashMap<Long, ValidatedLoggableElement> elementsById = new LinkedHashMap<Long, ValidatedLoggableElement>();
        LinkedHashMap<String, AnnotatedLoggableElement> rawElementsByName = new LinkedHashMap<String, AnnotatedLoggableElement>();
        LinkedHashMap<Long, AnnotatedLoggableElement> rawElementsById = new LinkedHashMap<Long, AnnotatedLoggableElement>();
        for (AnnotatedLoggableElement annotatedElement : configProto.getElementList()) {
            if (annotatedElement.getElement().getId() == -1L) {
                Preconditions.checkState((!annotatedElement.getHasMetadata() ? 1 : 0) != 0, (Object)"UndefinedVe cannot have metadata.");
            }
            LoggableElement element = annotatedElement.getElement();
            String name = element.getName();
            Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(name), (String)"'%s' is not a valid identifier", (Object)name);
            Preconditions.checkArgument((-9007199254740991L <= element.getId() && element.getId() <= 0x1FFFFFFFFFFFFFL ? 1 : 0) != 0, (String)"ID %s for '%s' must be between %s and %s (inclusive).", (Object)element.getId(), (Object)name, (Object)-9007199254740991L, (Object)0x1FFFFFFFFFFFFFL);
            ValidatedLoggableElement elementConfig = ValidatedLoggableElement.create(annotatedElement);
            ValidatedLoggableElement oldWithSameId = elementsById.put(elementConfig.getId(), elementConfig);
            if (oldWithSameId != null && !ValidatedLoggingConfig.elementsEquivalent(annotatedElement, (AnnotatedLoggableElement)rawElementsById.get(elementConfig.getId()))) {
                throw new IllegalArgumentException(String.format("Found 2 LoggableElements with the same id %d:\n\n%s\nand\n\n%s", elementConfig.getId(), annotatedElement, rawElementsById.get(elementConfig.getId())));
            }
            rawElementsById.put(elementConfig.getId(), annotatedElement);
            ValidatedLoggableElement oldWithSameName = elementsByName.put(elementConfig.getName(), elementConfig);
            if (oldWithSameName != null && !ValidatedLoggingConfig.elementsEquivalent(annotatedElement, (AnnotatedLoggableElement)rawElementsByName.get(elementConfig.getName()))) {
                throw new IllegalArgumentException(String.format("Found 2 LoggableElements with the same name %s:\n\n%s\nand\n\n%s", elementConfig.getName(), annotatedElement, rawElementsByName.get(elementConfig.getName())));
            }
            rawElementsByName.put(elementConfig.getName(), annotatedElement);
        }
        Preconditions.checkState((elementsByName.containsKey(UNDEFINED_VE_NAME) && ((ValidatedLoggableElement)elementsByName.get(UNDEFINED_VE_NAME)).getId() == -1L ? 1 : 0) != 0, (Object)"Logging config is missing UndefinedVe.");
        return new ValidatedLoggingConfig((ImmutableMap<String, ValidatedLoggableElement>)ImmutableMap.copyOf(elementsByName));
    }

    private static boolean elementsEquivalent(AnnotatedLoggableElement a1, AnnotatedLoggableElement a2) {
        AnnotatedLoggableElement mod1 = ValidatedLoggingConfig.createForComparison(a1);
        AnnotatedLoggableElement mod2 = ValidatedLoggingConfig.createForComparison(a2);
        return mod1.equals(mod2);
    }

    private static AnnotatedLoggableElement createForComparison(AnnotatedLoggableElement e) {
        return e.toBuilder().clearJavaPackage().clearJsPackage().clearClassName().build();
    }

    private ValidatedLoggingConfig(ImmutableMap<String, ValidatedLoggableElement> elementsByName) {
        this.elementsByName = elementsByName;
    }

    @Nullable
    public ValidatedLoggableElement getElement(String identifier) {
        return (ValidatedLoggableElement)this.elementsByName.get((Object)identifier);
    }

    public ImmutableSet<String> allKnownIdentifiers() {
        return this.elementsByName.keySet();
    }

    @AutoValue
    public static abstract class ValidatedLoggableElement {
        static ValidatedLoggableElement create(AnnotatedLoggableElement annotatedElement) {
            LoggableElement element = annotatedElement.getElement();
            return new AutoValue_ValidatedLoggingConfig_ValidatedLoggableElement(element.getName(), element.getId(), Optional.ofNullable(Strings.emptyToNull((String)element.getProtoType())), annotatedElement.getJavaPackage(), annotatedElement.getJsPackage(), annotatedElement.getClassName(), annotatedElement.getHasMetadata());
        }

        ValidatedLoggableElement() {
        }

        public abstract String getName();

        public abstract long getId();

        public abstract Optional<String> getProtoName();

        public abstract String getJavaPackage();

        public abstract String getJsPackage();

        public abstract String getClassName();

        public abstract boolean hasMetadata();

        public final String getGeneratedVeMetadataMethodName() {
            return String.format("v%s", this.getId());
        }
    }
}

