/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.google.errorprone.annotations.ForOverride;
import com.google.protobuf.Descriptors;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.internal.AutoValue_NullSafeAccumulator_Call;
import com.google.template.soy.jssrc.internal.AutoValue_NullSafeAccumulator_Id;
import com.google.template.soy.jssrc.internal.AutoValue_NullSafeAccumulator_ProtoCall;
import com.google.template.soy.jssrc.internal.JsRuntime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

final class NullSafeAccumulator {
    private final Expression base;
    private final List<ChainAccess> chain;

    NullSafeAccumulator(Expression base) {
        this.base = base;
        this.chain = new ArrayList<ChainAccess>();
    }

    NullSafeAccumulator dotAccess(FieldAccess access, boolean nullSafe, boolean assertNonNull) {
        this.chain.add(access.toChainAccess(nullSafe, assertNonNull));
        return this;
    }

    NullSafeAccumulator mapGetAccess(Expression mapKeyCode, boolean nullSafe, boolean assertNonNull) {
        this.chain.add(FieldAccess.call("get", mapKeyCode).toChainAccess(nullSafe, assertNonNull));
        return this;
    }

    NullSafeAccumulator bracketAccess(Expression arg, boolean nullSafe, boolean assertNonNull) {
        this.chain.add(new Bracket(arg, nullSafe, assertNonNull));
        return this;
    }

    NullSafeAccumulator functionCall(boolean nullSafe, boolean assertNonNull, Function<Expression, Expression> extender) {
        this.chain.add(new FunctionCall(nullSafe, assertNonNull, extender));
        return this;
    }

    Expression result(CodeChunk.Generator codeGenerator) {
        return NullSafeAccumulator.buildAccessChain(this.base, codeGenerator, this.chain.iterator(), new ArrayDeque<ChainAccess>());
    }

    private static Expression buildAccessChain(Expression base, CodeChunk.Generator generator, Iterator<ChainAccess> chain, Deque<ChainAccess> unpackBuffer) {
        if (!chain.hasNext()) {
            return NullSafeAccumulator.flushUnpackBuffer(base, unpackBuffer);
        }
        ChainAccess link = chain.next();
        if (link.nullSafe && !base.isCheap()) {
            base = generator.declarationBuilder().setRhs(base).build().ref();
        }
        Expression newBase = base;
        if (link.getUnpacking() == Unpacking.STOP) {
            newBase = NullSafeAccumulator.flushUnpackBuffer(newBase, unpackBuffer);
        }
        newBase = link.extend(newBase);
        unpackBuffer.addFirst(link);
        Expression result = link.nullSafe ? Expression.ifExpression(base.doubleEqualsNull(), Expression.LITERAL_NULL).setElse(NullSafeAccumulator.buildAccessChain(newBase, generator, chain, unpackBuffer)).build(generator) : NullSafeAccumulator.buildAccessChain(newBase, generator, chain, unpackBuffer);
        if (link.assertNonNull) {
            result = JsRuntime.SOY_CHECK_NOT_NULL.call(result);
        }
        return result;
    }

    private static Expression flushUnpackBuffer(Expression base, Deque<ChainAccess> unpackBuffer) {
        boolean tail = true;
        for (ChainAccess link : unpackBuffer) {
            Unpacking unpacking = link.getUnpacking();
            if (unpacking == Unpacking.UNPACK) {
                base = link.unpack(base, tail);
                break;
            }
            tail = false;
        }
        unpackBuffer.clear();
        return base;
    }

    static enum AccessType {
        SINGULAR{

            @Override
            Expression unpackResult(Expression accessChain, Expression unpackFunction) {
                return unpackFunction.call(accessChain);
            }
        }
        ,
        REPEATED{

            @Override
            Expression unpackResult(Expression accessChain, Expression unpackFunction) {
                return JsRuntime.GOOG_ARRAY_MAP.call(accessChain, unpackFunction);
            }
        }
        ,
        MAP{

            @Override
            Expression unpackResult(Expression accessChain, Expression unpackFunction) {
                return JsRuntime.SOY_NEWMAPS_TRANSFORM_VALUES.call(accessChain, unpackFunction);
            }
        };


        abstract Expression unpackResult(Expression var1, Expression var2);

        private static AccessType get(Descriptors.FieldDescriptor desc) {
            if (desc.isMapField()) {
                return MAP;
            }
            if (desc.isRepeated()) {
                return REPEATED;
            }
            return SINGULAR;
        }
    }

    @AutoValue
    static abstract class ProtoCall
    extends FieldAccess {
        ProtoCall() {
        }

        abstract String getter();

        @Nullable
        abstract Expression getterArg();

        @Nullable
        abstract AccessType accessType();

        @Nullable
        abstract Expression unpackFunction();

        static ProtoCall getField(String fieldName, Descriptors.FieldDescriptor desc) {
            return ProtoCall.accessor(fieldName, desc, Type.GET);
        }

        static ProtoCall hasField(String fieldName, Descriptors.FieldDescriptor desc) {
            return ProtoCall.accessor(fieldName, desc, Type.HAS);
        }

        private static ProtoCall accessor(String fieldName, Descriptors.FieldDescriptor desc, Type prefix) {
            Expression arg;
            String getter;
            Expression unpackFunction = null;
            if (desc.isExtension() && Type.HAS == prefix) {
                throw new IllegalArgumentException("hasExtension() not implemented");
            }
            if (Type.HAS == prefix && desc.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                throw new IllegalArgumentException("Submessage hasser not implemented");
            }
            if (Type.GET == prefix) {
                unpackFunction = ProtoCall.getUnpackFunction(desc);
            }
            if (desc.isExtension()) {
                getter = prefix.getPrefix() + "Extension";
                arg = JsRuntime.extensionField(desc);
            } else {
                getter = prefix.getPrefix() + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
                arg = null;
            }
            return new AutoValue_NullSafeAccumulator_ProtoCall(getter, arg, unpackFunction == null ? null : AccessType.get(desc), unpackFunction);
        }

        @Override
        ChainAccess toChainAccess(boolean nullSafe, boolean assertNonNull) {
            return new ProtoDotCall(nullSafe, assertNonNull, this);
        }

        @Nullable
        private static Expression getUnpackFunction(Descriptors.FieldDescriptor desc) {
            if (ProtoUtils.isSanitizedContentField(desc)) {
                return JsRuntime.protoToSanitizedContentConverterFunction(desc.getMessageType());
            }
            if (ProtoUtils.isSanitizedContentMap(desc)) {
                return JsRuntime.protoToSanitizedContentConverterFunction(ProtoUtils.getMapValueMessageType(desc));
            }
            return null;
        }

        private static enum Type {
            GET("get"),
            HAS("has");

            private final String prefix;

            private Type(String prefix) {
                this.prefix = prefix;
            }

            public String getPrefix() {
                return this.prefix;
            }
        }
    }

    @AutoValue
    static abstract class Call
    extends FieldAccess {
        Call() {
        }

        abstract String getter();

        @Nullable
        abstract Expression arg();

        @Override
        ChainAccess toChainAccess(boolean nullSafe, boolean assertNonNull) {
            return new DotCall(this.getter(), this.arg(), nullSafe, assertNonNull);
        }
    }

    @AutoValue
    static abstract class Id
    extends FieldAccess {
        Id() {
        }

        abstract String fieldName();

        @Override
        ChainAccess toChainAccess(boolean nullSafe, boolean assertNonNull) {
            return new Dot(this.fieldName(), nullSafe, assertNonNull);
        }
    }

    static abstract class FieldAccess {
        FieldAccess() {
        }

        @ForOverride
        abstract ChainAccess toChainAccess(boolean var1, boolean var2);

        static FieldAccess id(String fieldName) {
            return new AutoValue_NullSafeAccumulator_Id(fieldName);
        }

        static FieldAccess call(String getter, Expression arg) {
            return new AutoValue_NullSafeAccumulator_Call(getter, arg);
        }

        static FieldAccess protoCall(String fieldName, Descriptors.FieldDescriptor desc) {
            return ProtoCall.getField(fieldName, desc);
        }
    }

    private static final class ProtoDotCall
    extends ChainAccess {
        private final ProtoCall protoCall;

        ProtoDotCall(boolean nullSafe, boolean assertNonNull, ProtoCall protoCall) {
            super(nullSafe, assertNonNull);
            this.protoCall = protoCall;
        }

        @Override
        Expression extend(Expression prevTip) {
            Expression arg = this.protoCall.getterArg();
            String getter = this.protoCall.getter();
            Expression result = arg == null ? prevTip.dotAccess(getter).call(new Expression[0]) : prevTip.dotAccess(getter).call(arg);
            return result;
        }

        @Override
        Expression unpack(Expression base, boolean tail) {
            AccessType accessType = tail ? this.protoCall.accessType() : AccessType.SINGULAR;
            return accessType.unpackResult(base, this.protoCall.unpackFunction());
        }

        @Override
        Unpacking getUnpacking() {
            return this.protoCall.unpackFunction() != null ? Unpacking.UNPACK : Unpacking.PASS;
        }
    }

    private static class DotCall
    extends ChainAccess {
        final String getter;
        @Nullable
        final Expression arg;

        DotCall(String getter, @Nullable Expression arg, boolean nullSafe, boolean assertNonNull) {
            super(nullSafe, assertNonNull);
            this.getter = getter;
            this.arg = arg;
        }

        @Override
        final Expression extend(Expression prevTip) {
            return this.arg == null ? prevTip.dotAccess(this.getter).call(new Expression[0]) : prevTip.dotAccess(this.getter).call(this.arg);
        }
    }

    private static final class Dot
    extends ChainAccess {
        final String id;

        Dot(String id, boolean nullSafe, boolean assertNonNull) {
            super(nullSafe, assertNonNull);
            this.id = id;
        }

        @Override
        Expression extend(Expression prevTip) {
            return prevTip.dotAccess(this.id);
        }
    }

    private static final class Bracket
    extends ChainAccess {
        final Expression value;

        Bracket(Expression value, boolean nullSafe, boolean assertNonNull) {
            super(nullSafe, assertNonNull);
            this.value = value;
        }

        @Override
        Expression extend(Expression prevTip) {
            return prevTip.bracketAccess(this.value);
        }
    }

    private static final class FunctionCall
    extends ChainAccess {
        private final Function<Expression, Expression> funct;

        public FunctionCall(boolean nullSafe, boolean assertNonNull, Function<Expression, Expression> funct) {
            super(nullSafe, assertNonNull);
            this.funct = funct;
        }

        @Override
        Expression extend(Expression prevTip) {
            prevTip = JsRuntime.SOY_CHECK_NOT_NULL.call(prevTip);
            return this.funct.apply(prevTip);
        }

        @Override
        Unpacking getUnpacking() {
            return Unpacking.STOP;
        }
    }

    private static abstract class ChainAccess {
        final boolean nullSafe;
        final boolean assertNonNull;

        abstract Expression extend(Expression var1);

        ChainAccess(boolean nullSafe, boolean assertNonNull) {
            this.nullSafe = nullSafe;
            this.assertNonNull = assertNonNull;
        }

        Expression unpack(Expression base, boolean tail) {
            throw new UnsupportedOperationException();
        }

        Unpacking getUnpacking() {
            return Unpacking.PASS;
        }
    }

    private static enum Unpacking {
        UNPACK,
        PASS,
        STOP;

    }
}

