/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.types.LegacyObjectMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnionType;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public final class JsType {
    private static final JsType ANY_TYPE = JsType.builder().addType("*").setPredicate(TypePredicate.NO_OP).build();
    private static final JsType UNKNOWN_TYPE = JsType.builder().addType("?").setPredicate(TypePredicate.NO_OP).build();
    private static final JsType BOOLEAN_TYPE = JsType.builder().addType("boolean").setPredicate(JsType.typeofTypePredicate("boolean")).build();
    private static final JsType NUMBER_TYPE = JsType.builder().addType("number").setPredicate(JsType.typeofTypePredicate("number")).build();
    private static final JsType STRING_TYPE = JsType.builder().addType("string").setPredicate(JsType.typeofTypePredicate("string")).build();
    private static final JsType MESSAGE_TYPE = JsType.builder().addType("!jspb.Message").setPredicate((value, codeGenerator) -> Optional.of(value.instanceOf(GoogRequire.create("jspb.Message").reference()))).addRequire(GoogRequire.create("jspb.Message")).build();
    private static final JsType RAW_ARRAY_TYPE = JsType.builder().addType("!Array").setPredicate(JsRuntime.ARRAY_IS_ARRAY).build();
    private static final JsType RAW_OBJECT_TYPE = JsType.builder().addType("!Object").setPredicate(JsRuntime.GOOG_IS_OBJECT).build();
    private static final JsType NULL_OR_UNDEFINED_TYPE = JsType.builder().addType("null").addType("undefined").setPredicate((value, codeGenerator) -> Optional.of(value.doubleEqualsNull())).build();
    private static final ImmutableMap<SanitizedContentKind, JsType> SANITIZED_TYPES;
    private static final ImmutableMap<SanitizedContentKind, JsType> SANITIZED_TYPES_STRICT;
    private static final JsType IDOM_ATTRIBUTES;
    private static final GoogRequire SANITIZED_CONTENT_KIND;
    private static final Expression IS_IDOM_FUNCTION_TYPE;
    private static final JsType IDOM_HTML;
    private static final JsType VE_TYPE;
    private static final JsType VE_DATA_TYPE;
    private final ImmutableSortedSet<String> typeExpressions;
    private final ImmutableSet<GoogRequire> extraRequires;
    private final ImmutableSet<ValueCoercionStrategy> coercionStrategies;
    private final TypePredicate predicate;

    public static JsType forJsSrc(SoyType soyType) {
        return JsType.forSoyType(soyType, false, false);
    }

    public static JsType forJsSrcStrict(SoyType soyType) {
        return JsType.forSoyType(soyType, false, true);
    }

    public static JsType forIncrementalDom(SoyType soyType) {
        return JsType.forSoyType(soyType, true, false);
    }

    public static JsType forIncrementalDomState(SoyType soyType) {
        return JsType.forSoyType(soyType, true, true);
    }

    private static JsType forSoyType(SoyType soyType, boolean isIncrementalDom, boolean isStrict) {
        switch (soyType.getKind()) {
            case NULL: {
                return NULL_OR_UNDEFINED_TYPE;
            }
            case ANY: {
                return ANY_TYPE;
            }
            case UNKNOWN: {
                return UNKNOWN_TYPE;
            }
            case BOOL: {
                return BOOLEAN_TYPE;
            }
            case PROTO_ENUM: {
                SoyProtoEnumType enumType = (SoyProtoEnumType)soyType;
                String enumTypeName = enumType.getNameForBackend(SoyBackendKind.JS_SRC);
                Builder enumBuilder = JsType.builder().addType("!" + enumTypeName).addRequire(GoogRequire.createTypeRequire(enumTypeName)).setPredicate(JsType.typeofTypePredicate("number"));
                if (!isStrict) {
                    enumBuilder.addType("number");
                }
                return enumBuilder.build();
            }
            case FLOAT: 
            case INT: {
                return NUMBER_TYPE;
            }
            case STRING: {
                return STRING_TYPE;
            }
            case ATTRIBUTES: {
                if (isIncrementalDom) {
                    return IDOM_ATTRIBUTES;
                }
            }
            case HTML: {
                if (isIncrementalDom) {
                    return IDOM_HTML;
                }
            }
            case CSS: 
            case JS: 
            case URI: 
            case TRUSTED_RESOURCE_URI: {
                return isStrict ? (JsType)SANITIZED_TYPES_STRICT.get((Object)((SanitizedType)soyType).getContentKind()) : (JsType)SANITIZED_TYPES.get((Object)((SanitizedType)soyType).getContentKind());
            }
            case LIST: {
                ListType listType = (ListType)soyType;
                if (listType.getElementType().getKind() == SoyType.Kind.ANY) {
                    return RAW_ARRAY_TYPE;
                }
                JsType element = JsType.forSoyType(listType.getElementType(), isIncrementalDom, isStrict);
                return JsType.builder().addType("!Array<" + element.typeExpr() + ">").addRequires((Iterable<GoogRequire>)element.getGoogRequires()).setPredicate(JsRuntime.ARRAY_IS_ARRAY).build();
            }
            case LEGACY_OBJECT_MAP: {
                LegacyObjectMapType mapType = (LegacyObjectMapType)soyType;
                if (mapType.getKeyType().getKind() == SoyType.Kind.ANY && mapType.getValueType().getKind() == SoyType.Kind.ANY) {
                    return RAW_OBJECT_TYPE;
                }
                JsType keyTypeName = JsType.forSoyType(mapType.getKeyType(), isIncrementalDom, isStrict);
                JsType valueTypeName = JsType.forSoyType(mapType.getValueType(), isIncrementalDom, isStrict);
                return JsType.builder().addType(String.format("!Object<%s,%s>", keyTypeName.typeExpr(), valueTypeName.typeExpr())).addRequires((Iterable<GoogRequire>)keyTypeName.getGoogRequires()).addRequires((Iterable<GoogRequire>)valueTypeName.getGoogRequires()).setPredicate(JsRuntime.GOOG_IS_OBJECT).build();
            }
            case MAP: {
                MapType mapType = (MapType)soyType;
                SoyType keyType = mapType.getKeyType();
                SoyType.Kind keyKind = keyType.getKind();
                Preconditions.checkState((boolean)MapType.isAllowedKeyType(keyType));
                JsType keyTypeName = keyKind == SoyType.Kind.STRING ? STRING_TYPE : JsType.forSoyType(keyType, isIncrementalDom, isStrict);
                JsType valueTypeName = JsType.forSoyType(mapType.getValueType(), isIncrementalDom, isStrict);
                return JsType.builder().addType(String.format("!soy.map.Map<%s,%s>", keyTypeName.typeExpr(), valueTypeName.typeExpr())).addRequires((Iterable<GoogRequire>)keyTypeName.getGoogRequires()).addRequires((Iterable<GoogRequire>)valueTypeName.getGoogRequires()).addRequire(GoogRequire.create("soy.map")).setPredicate(JsRuntime.SOY_MAP_IS_SOY_MAP).build();
            }
            case MESSAGE: {
                return MESSAGE_TYPE;
            }
            case PROTO: {
                SoyProtoType protoType = (SoyProtoType)soyType;
                String protoTypeName = protoType.getNameForBackend(SoyBackendKind.JS_SRC);
                return JsType.builder().addType(isStrict ? "!" + protoTypeName : protoTypeName).addRequire(GoogRequire.create(protoTypeName)).addCoercionStrategy(ValueCoercionStrategy.PROTO).setPredicate((value, codeGenerator) -> Optional.of(value.instanceOf(JsRuntime.protoConstructor(protoType)))).build();
            }
            case RECORD: {
                RecordType recordType = (RecordType)soyType;
                Preconditions.checkArgument((!recordType.getMembers().isEmpty() ? 1 : 0) != 0);
                Builder builder = JsType.builder();
                LinkedHashMap<String, String> members = new LinkedHashMap<String, String>();
                for (RecordType.Member member : recordType.getMembers()) {
                    JsType forSoyType = JsType.forSoyType(member.type(), isIncrementalDom, isStrict);
                    builder.addRequires((Iterable<GoogRequire>)forSoyType.getGoogRequires());
                    members.put(member.name(), forSoyType.typeExprForRecordMember(false));
                }
                return builder.addType("{" + Joiner.on((String)", ").withKeyValueSeparator(": ").join(members) + ",}").setPredicate(JsRuntime.GOOG_IS_OBJECT).build();
            }
            case UNION: {
                UnionType unionType = (UnionType)soyType;
                Builder builder = JsType.builder();
                LinkedHashSet<JsType> types = new LinkedHashSet<JsType>();
                boolean isNullable = unionType.isNullable();
                if (isNullable) {
                    builder.addTypes((Iterable<String>)JsType.NULL_OR_UNDEFINED_TYPE.typeExpressions);
                    builder.addCoercionStrategy(ValueCoercionStrategy.NULL);
                    types.add(NULL_OR_UNDEFINED_TYPE);
                }
                for (SoyType member : unionType.getMembers()) {
                    if (member.getKind() == SoyType.Kind.NULL) continue;
                    JsType memberType = JsType.forSoyType(member, isIncrementalDom, isStrict);
                    builder.addRequires((Iterable<GoogRequire>)memberType.extraRequires);
                    builder.addTypes((Iterable<String>)memberType.typeExpressions);
                    builder.addCoercionStrategies((Iterable<ValueCoercionStrategy>)memberType.coercionStrategies);
                    types.add(memberType);
                }
                return builder.setPredicate((value, codeGenerator) -> {
                    Expression result = null;
                    for (JsType memberType : types) {
                        Optional<Expression> typeAssertion = memberType.getTypeAssertion(value, codeGenerator);
                        if (!typeAssertion.isPresent()) {
                            return Optional.empty();
                        }
                        if (result == null) {
                            result = typeAssertion.get();
                            continue;
                        }
                        result = result.or(typeAssertion.get(), codeGenerator);
                    }
                    return Optional.of(result);
                }).build();
            }
            case VE: {
                return VE_TYPE;
            }
            case VE_DATA: {
                return VE_DATA_TYPE;
            }
            case TEMPLATE: {
                TemplateType templateType = (TemplateType)soyType;
                Builder builder = JsType.builder();
                LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                for (TemplateType.Parameter parameter : templateType.getParameters()) {
                    JsType forSoyType = JsType.forSoyType(parameter.getType(), isIncrementalDom, isStrict);
                    builder.addRequires((Iterable<GoogRequire>)forSoyType.getGoogRequires());
                    parameters.put(parameter.getName(), forSoyType.typeExprForRecordMember(!parameter.isRequired()));
                }
                JsType forReturnType = JsType.templateReturnType(templateType.getContentKind(), isIncrementalDom);
                builder.addRequires((Iterable<GoogRequire>)forReturnType.getGoogRequires());
                String parametersType = parameters.isEmpty() ? "null" : "{" + Joiner.on((String)", ").withKeyValueSeparator(": ").join(parameters) + ",}";
                String ijType = "?goog.soy.IjData";
                String returnType = forReturnType.typeExpr();
                if (isIncrementalDom) {
                    builder.addRequire(GoogRequire.createWithAlias("google3.javascript.template.soy.api_idom", "incrementaldomlib"));
                    builder.addType(String.format("function(!incrementaldomlib.IncrementalDomRenderer, %s, %s):(%s)", parametersType, ijType, returnType));
                } else {
                    builder.addType(String.format("function(%s, %s):(%s)", parametersType, ijType, returnType));
                }
                builder.setPredicate(JsRuntime.GOOG_IS_FUNCTION);
                return builder.build();
            }
        }
        throw new AssertionError((Object)("unhandled soytype: " + soyType));
    }

    private static JsType templateReturnType(SanitizedContentKind templateReturnType, boolean isIncrementalDom) {
        switch (templateReturnType) {
            case TEXT: {
                return STRING_TYPE;
            }
            case ATTRIBUTES: 
            case CSS: 
            case HTML: 
            case JS: 
            case URI: 
            case TRUSTED_RESOURCE_URI: {
                Builder builder = JsType.builder();
                String type = NodeContentKinds.toJsSanitizedContentCtorName(templateReturnType);
                if (isIncrementalDom && (templateReturnType == SanitizedContentKind.HTML || templateReturnType == SanitizedContentKind.ATTRIBUTES)) {
                    builder.addType("void");
                } else {
                    builder.addType("!" + type);
                }
                builder.setPredicate(TypePredicate.NO_OP);
                return builder.build();
            }
        }
        throw new IllegalStateException("Unsupported return type found for template type; this should have been caught earlier in parsing.");
    }

    private static TypePredicate typeofTypePredicate(String type) {
        return (value, codeGenerator) -> Optional.of(value.typeof().tripleEquals(Expression.stringLiteral(type)));
    }

    private JsType(Builder builder) {
        this.typeExpressions = builder.typeExpressions.build();
        Preconditions.checkArgument((!this.typeExpressions.isEmpty() ? 1 : 0) != 0);
        this.coercionStrategies = Sets.immutableEnumSet(builder.coercionStrategies);
        this.extraRequires = builder.extraRequires.build();
        this.predicate = (TypePredicate)Preconditions.checkNotNull((Object)builder.predicate);
    }

    public String typeExpr() {
        return Joiner.on((char)'|').join(this.typeExpressions);
    }

    public String typeExprForRecordMember(boolean isOptional) {
        if (this.typeExpressions.size() > 1 || isOptional) {
            return "(" + this.typeExpr() + (isOptional && !this.typeExpressions.contains((Object)"undefined") ? "|undefined" : "") + ")";
        }
        return this.typeExpr();
    }

    public final ImmutableSet<GoogRequire> getGoogRequires() {
        return this.extraRequires;
    }

    final Optional<Expression> getTypeAssertion(Expression value, CodeChunk.Generator codeGenerator) {
        return this.predicate.maybeCheck(value, codeGenerator);
    }

    public final Optional<Expression> getSoyTypeAssertion(Expression value, String valueName, CodeChunk.Generator codeGenerator) {
        Optional<Expression> typeAssertion = this.getTypeAssertion(value, codeGenerator);
        if (!typeAssertion.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(JsRuntime.SOY_ASSERTS_ASSERT_TYPE.call(typeAssertion.get(), Expression.stringLiteral(valueName), value, Expression.stringLiteral(this.typeExpr())));
    }

    @Nullable
    final Expression getValueCoercion(Expression value, CodeChunk.Generator codeGenerator, boolean hasDefault) {
        boolean needsProtoCoercion = this.coercionStrategies.contains((Object)ValueCoercionStrategy.PROTO);
        if (!needsProtoCoercion) {
            return null;
        }
        Expression coercion = value.castAs("?").dotAccess("$jspbMessageInstance").or(value, codeGenerator);
        return value.and(coercion, codeGenerator);
    }

    private static JsType createSanitized(SanitizedContentKind kind, boolean isStrict) {
        if (kind == SanitizedContentKind.TEXT) {
            return STRING_TYPE;
        }
        String type = NodeContentKinds.toJsSanitizedContentCtorName(kind);
        Builder builder = JsType.builder();
        builder.addType("!soydata.$$EMPTY_STRING_");
        builder.addType("!" + type);
        builder.addRequire(GoogRequire.create(type));
        if (!isStrict) {
            builder.addType("string");
        } else {
            builder.addType("!soydata.$$EMPTY_STRING_");
            builder.addType("!" + type);
            builder.addRequire(GoogRequire.create(type));
            if (!isStrict) {
                builder.addType("string");
            }
        }
        switch (kind) {
            case CSS: {
                builder.addType("!goog.html.SafeStyle");
                break;
            }
            case HTML: {
                builder.addType("!goog.html.SafeHtml");
                break;
            }
            case JS: {
                builder.addType("!goog.html.SafeScript");
                break;
            }
            case TEXT: 
            case ATTRIBUTES: {
                break;
            }
            case TRUSTED_RESOURCE_URI: {
                builder.addType("!goog.html.TrustedResourceUrl");
                break;
            }
            case URI: {
                builder.addType("!goog.html.TrustedResourceUrl");
                builder.addType("!goog.html.SafeUrl");
                builder.addType("!goog.Uri");
            }
        }
        String compatibleWithString = isStrict ? "isCompatibleWithStrict" : "isCompatibleWith";
        return builder.setPredicate((value, codeGenerator) -> Optional.of(JsRuntime.sanitizedContentType(kind).dotAccess(compatibleWithString).call(value))).build();
    }

    private static Builder builder() {
        return new Builder();
    }

    static {
        IDOM_ATTRIBUTES = JsType.builder().addType("function()").addType("!google3.javascript.template.soy.element_lib_idom.IdomFunction").addRequire(GoogRequire.createTypeRequire("google3.javascript.template.soy.element_lib_idom")).setPredicate(JsRuntime.GOOG_IS_FUNCTION).build();
        SANITIZED_CONTENT_KIND = GoogRequire.createWithAlias("goog.soy.data.SanitizedContentKind", "SanitizedContentKind");
        IS_IDOM_FUNCTION_TYPE = GoogRequire.create("google3.javascript.template.soy.soyutils_directives").googModuleGet().dotAccess("$$isIdomFunctionType");
        IDOM_HTML = JsType.builder().addType("!goog.soy.data.SanitizedHtml").addType("!goog.html.SafeHtml").addRequire(GoogRequire.createTypeRequire("goog.html.SafeHtml")).addRequire(GoogRequire.createTypeRequire("goog.soy.data.SanitizedHtml")).addType("!google3.javascript.template.soy.element_lib_idom.IdomFunction").addRequire(GoogRequire.createTypeRequire("google3.javascript.template.soy.element_lib_idom")).addType("function(!incrementaldomlib.IncrementalDomRenderer): undefined").addRequire(GoogRequire.createWithAlias("google3.javascript.template.soy.api_idom", "incrementaldomlib")).setPredicate((value, codeGenerator) -> Optional.of(IS_IDOM_FUNCTION_TYPE.call(value, SANITIZED_CONTENT_KIND.dotAccess("HTML")).or(value.instanceOf(JsRuntime.GOOG_HTML_SAFE_HTML), codeGenerator).or(value.instanceOf(JsRuntime.GOOG_SOY_DATA_SANITIZED_CONTENT), codeGenerator))).build();
        VE_TYPE = JsType.builder().addType("!soy.velog.$$VisualElement").addRequire(JsRuntime.SOY_VELOG).setPredicate((value, codeGenerator) -> Optional.of(value.instanceOf(JsRuntime.SOY_VISUAL_ELEMENT))).build();
        VE_DATA_TYPE = JsType.builder().addType("!soy.velog.$$VisualElementData").addRequire(JsRuntime.SOY_VELOG).setPredicate((value, codeGenerator) -> Optional.of(value.instanceOf(JsRuntime.SOY_VISUAL_ELEMENT_DATA))).build();
        EnumMap<SanitizedContentKind, JsType> types = new EnumMap<SanitizedContentKind, JsType>(SanitizedContentKind.class);
        EnumMap<SanitizedContentKind, JsType> typesStrict = new EnumMap<SanitizedContentKind, JsType>(SanitizedContentKind.class);
        for (SanitizedContentKind kind : SanitizedContentKind.values()) {
            types.put(kind, JsType.createSanitized(kind, false));
            typesStrict.put(kind, JsType.createSanitized(kind, true));
        }
        SANITIZED_TYPES = Maps.immutableEnumMap(types);
        SANITIZED_TYPES_STRICT = Maps.immutableEnumMap(typesStrict);
    }

    private static final class Builder {
        final ImmutableSortedSet.Builder<String> typeExpressions = ImmutableSortedSet.naturalOrder();
        final ImmutableSet.Builder<GoogRequire> extraRequires = ImmutableSet.builder();
        final Set<ValueCoercionStrategy> coercionStrategies = EnumSet.noneOf(ValueCoercionStrategy.class);
        @Nullable
        TypePredicate predicate;

        private Builder() {
        }

        Builder addType(String typeExpr) {
            this.typeExpressions.add((Object)typeExpr);
            return this;
        }

        Builder addTypes(Iterable<String> typeExpressions) {
            this.typeExpressions.addAll(typeExpressions);
            return this;
        }

        Builder addRequire(GoogRequire symbol) {
            this.extraRequires.add((Object)symbol);
            return this;
        }

        Builder addRequires(Iterable<GoogRequire> symbols) {
            this.extraRequires.addAll(symbols);
            return this;
        }

        Builder addCoercionStrategy(ValueCoercionStrategy strategy) {
            this.coercionStrategies.add(strategy);
            return this;
        }

        Builder addCoercionStrategies(Iterable<ValueCoercionStrategy> strategies) {
            Iterables.addAll(this.coercionStrategies, strategies);
            return this;
        }

        Builder setPredicate(TypePredicate predicate) {
            Preconditions.checkState((this.predicate == null ? 1 : 0) != 0);
            this.predicate = (TypePredicate)Preconditions.checkNotNull((Object)predicate);
            return this;
        }

        Builder setPredicate(Expression predicateFunction) {
            return this.setPredicate((Expression value, CodeChunk.Generator codeGenerator) -> Optional.of(((Expression)Preconditions.checkNotNull((Object)predicateFunction)).call(value)));
        }

        JsType build() {
            return new JsType(this);
        }
    }

    private static interface TypePredicate {
        public static final TypePredicate NO_OP = (value, codeGenerator) -> Optional.empty();

        public Optional<Expression> maybeCheck(Expression var1, CodeChunk.Generator var2);
    }

    private static enum ValueCoercionStrategy {
        NULL,
        PROTO;

    }
}

