/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.DelTemplateNamer;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.VeLogInstrumentationVisitor;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.InsertMsgsVisitor;
import com.google.template.soy.passes.CombineConsecutiveRawTextNodesPass;
import com.google.template.soy.shared.internal.SoyScopedData;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.List;
import javax.annotation.Nullable;

public class JsSrcMain {
    private final SoyScopedData.Enterable apiCallScope;
    private final SoyTypeRegistry typeRegistry;

    public JsSrcMain(SoyScopedData.Enterable apiCallScope, SoyTypeRegistry typeRegistry) {
        this.apiCallScope = apiCallScope;
        this.typeRegistry = typeRegistry;
    }

    public List<String> genJsSrc(SoyFileSetNode soyTree, TemplateRegistry templateRegistry, SoyJsSrcOptions jsSrcOptions, @Nullable SoyMsgBundle msgBundle, ErrorReporter errorReporter) {
        new VeLogInstrumentationVisitor(templateRegistry).exec(soyTree);
        BidiGlobalDir bidiGlobalDir = SoyBidiUtils.decodeBidiGlobalDirFromJsOptions(jsSrcOptions.getBidiGlobalDir(), jsSrcOptions.getUseGoogIsRtlForBidiGlobalDir());
        try (SoyScopedData.InScope inScope = this.apiCallScope.enter(msgBundle, bidiGlobalDir);){
            if (jsSrcOptions.shouldGenerateGoogMsgDefs()) {
                Preconditions.checkState((bidiGlobalDir != null ? 1 : 0) != 0, (Object)"If enabling shouldGenerateGoogMsgDefs, must also set bidi global directionality.");
            } else {
                Preconditions.checkState((bidiGlobalDir == null || bidiGlobalDir.isStaticValue() ? 1 : 0) != 0, (Object)"If using bidiGlobalIsRtlCodeSnippet, must also enable shouldGenerateGoogMsgDefs.");
                new InsertMsgsVisitor(msgBundle, errorReporter).insertMsgs(soyTree);
            }
            new CombineConsecutiveRawTextNodesPass().run(soyTree);
            List<String> list = JsSrcMain.createVisitor(jsSrcOptions, this.typeRegistry, inScope.getBidiGlobalDir(), errorReporter).gen(soyTree, templateRegistry, errorReporter);
            return list;
        }
    }

    static GenJsCodeVisitor createVisitor(SoyJsSrcOptions options, SoyTypeRegistry typeRegistry, BidiGlobalDir dir, ErrorReporter errorReporter) {
        GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;
        final DelTemplateNamer delTemplateNamer = new DelTemplateNamer();
        final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor = new IsComputableAsJsExprsVisitor();
        JavaScriptValueFactoryImpl javaScriptValueFactory = new JavaScriptValueFactoryImpl(dir, errorReporter);
        CanInitOutputVarVisitor canInitOutputVarVisitor = new CanInitOutputVarVisitor(isComputableAsJsExprsVisitor);
        class GenCallCodeUtilsSupplier
        implements Supplier<GenCallCodeUtils> {
            GenJsExprsVisitor.GenJsExprsVisitorFactory factory;

            GenCallCodeUtilsSupplier() {
            }

            public GenCallCodeUtils get() {
                return new GenCallCodeUtils(delTemplateNamer, isComputableAsJsExprsVisitor, this.factory);
            }
        }
        GenCallCodeUtilsSupplier supplier = new GenCallCodeUtilsSupplier();
        supplier.factory = genJsExprsVisitorFactory = new GenJsExprsVisitor.GenJsExprsVisitorFactory(javaScriptValueFactory, supplier, isComputableAsJsExprsVisitor);
        return new GenJsCodeVisitor(options, javaScriptValueFactory, delTemplateNamer, supplier.get(), isComputableAsJsExprsVisitor, canInitOutputVarVisitor, genJsExprsVisitorFactory, typeRegistry);
    }
}

