/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.internal.DelTemplateNamer;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GenCallCodeUtils {
    private final DelTemplateNamer delTemplateNamer;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;

    protected GenCallCodeUtils(DelTemplateNamer delTemplateNamer, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory) {
        this.delTemplateNamer = delTemplateNamer;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
    }

    public Expression gen(CallNode callNode, TemplateAliases templateAliases, TranslationContext translationContext, ErrorReporter errorReporter, TranslateExprNodeVisitor exprTranslator) {
        Expression callee = this.genCallee(callNode, templateAliases, exprTranslator);
        Expression objToPass = this.genObjToPass(callNode, templateAliases, translationContext, errorReporter, exprTranslator);
        Expression call = this.genMainCall(callee, objToPass, callNode);
        if (callNode.getEscapingDirectives().isEmpty()) {
            return call;
        }
        return GenCallCodeUtils.applyEscapingDirectives(call, callNode);
    }

    protected Expression genMainCall(Expression callee, Expression objToPass, CallNode call) {
        return callee.call(objToPass, JsRuntime.OPT_IJ_DATA);
    }

    public static Expression applyEscapingDirectives(Expression call, CallNode callNode) {
        JsExpr callResult = call.singleExprOrName();
        ImmutableSet.Builder requiresBuilder = ImmutableSet.builder();
        call.collectRequires(arg_0 -> ((ImmutableSet.Builder)requiresBuilder).add(arg_0));
        for (SoyPrintDirective directive : callNode.getEscapingDirectives()) {
            Preconditions.checkState((boolean)(directive instanceof SoyJsSrcPrintDirective), (String)"Contextual autoescaping produced a bogus directive: %s", (Object)directive.getName());
            callResult = ((SoyJsSrcPrintDirective)directive).applyForJsSrc(callResult, (List<JsExpr>)ImmutableList.of());
            if (!(directive instanceof SoyLibraryAssistedJsSrcPrintDirective)) continue;
            for (String name : ((SoyLibraryAssistedJsSrcPrintDirective)directive).getRequiredJsLibNames()) {
                requiresBuilder.add((Object)GoogRequire.create(name));
            }
        }
        return Expression.fromExpr(callResult, (Iterable<GoogRequire>)requiresBuilder.build()).withInitialStatements((Iterable<? extends Statement>)call.initialStatements());
    }

    public Expression genCallee(CallNode callNode, TemplateAliases templateAliases, TranslateExprNodeVisitor exprTranslator) {
        Expression callee;
        if (callNode instanceof CallBasicNode) {
            CallBasicNode callBasicNode = (CallBasicNode)callNode;
            Expression calleeExpression = (Expression)exprTranslator.exec(callBasicNode.getCalleeExpr());
            callee = callBasicNode.isStaticCall() ? calleeExpression : JsRuntime.ASSERT_TEMPLATE.call(calleeExpression);
        } else {
            CallDelegateNode callDelegateNode = (CallDelegateNode)callNode;
            Expression calleeId = JsRuntime.SOY_GET_DELTEMPLATE_ID.call(Expression.stringLiteral(this.delTemplateNamer.getDelegateName(callDelegateNode)));
            ExprRootNode variantSoyExpr = callDelegateNode.getDelCalleeVariantExpr();
            Expression variant = variantSoyExpr == null ? Expression.LITERAL_EMPTY_STRING : (Expression)exprTranslator.exec(variantSoyExpr);
            callee = JsRuntime.SOY_GET_DELEGATE_FN.call(calleeId, variant, callDelegateNode.allowEmptyDefault() ? Expression.LITERAL_TRUE : Expression.LITERAL_FALSE);
        }
        return callee;
    }

    public Expression genObjToPass(CallNode callNode, TemplateAliases templateAliases, TranslationContext translationContext, ErrorReporter errorReporter, TranslateExprNodeVisitor exprTranslator) {
        Expression dataToPass;
        if (callNode.isPassingAllData()) {
            dataToPass = JsRuntime.OPT_DATA;
        } else if (callNode.isPassingData()) {
            dataToPass = (Expression)exprTranslator.exec(callNode.getDataExpr());
        } else {
            if (callNode.numChildren() == 0) {
                return Expression.LITERAL_NULL;
            }
            dataToPass = Expression.LITERAL_NULL;
        }
        Map<String, Expression> paramDefaults = this.getDefaultParams(callNode, translationContext);
        if (callNode.numChildren() == 0) {
            if (!paramDefaults.isEmpty()) {
                dataToPass = JsRuntime.SOY_ASSIGN_DEFAULTS.call(dataToPass, Expression.objectLiteral(paramDefaults));
            }
            return dataToPass.castAs("?");
        }
        Map<String, Expression> params = paramDefaults;
        for (CallParamNode child : callNode.getChildren()) {
            Expression value;
            if (child instanceof CallParamValueNode) {
                CallParamValueNode cpvn = (CallParamValueNode)child;
                value = (Expression)exprTranslator.exec(cpvn.getExpr());
            } else {
                CallParamContentNode cpcn = (CallParamContentNode)child;
                if (((Boolean)this.isComputableAsJsExprsVisitor.exec(cpcn)).booleanValue()) {
                    List<Expression> chunks = this.genJsExprsVisitorFactory.create(translationContext, templateAliases, errorReporter).exec(cpcn);
                    value = CodeChunkUtils.concatChunksForceString(chunks);
                } else {
                    value = Expression.id("param" + cpcn.getId());
                }
                value = this.maybeWrapContent(translationContext.codeGenerator(), cpcn, value);
            }
            params.put(child.getKey().identifier(), value);
        }
        Expression paramsExp = Expression.objectLiteral(params);
        if (callNode.isPassingData()) {
            Expression allData = JsRuntime.SOY_ASSIGN_DEFAULTS.call(paramsExp, dataToPass);
            return allData;
        }
        return paramsExp.castAs("?");
    }

    private Map<String, Expression> getDefaultParams(CallNode node, TranslationContext translationContext) {
        LinkedHashMap<String, Expression> defaultParams = new LinkedHashMap<String, Expression>();
        if (!node.isPassingAllData()) {
            return defaultParams;
        }
        for (TemplateParam param : node.getNearestAncestor(TemplateNode.class).getParams()) {
            if (!param.hasDefault()) continue;
            defaultParams.put(param.name(), translationContext.soyToJsVariableMappings().get(param.name()));
        }
        return defaultParams;
    }

    protected Expression maybeWrapContent(CodeChunk.Generator generator, CallParamContentNode node, Expression content) {
        if (node.getContentKind() == SanitizedContentKind.TEXT) {
            return content;
        }
        return JsRuntime.sanitizedContentOrdainerFunctionForInternalBlocks(node.getContentKind()).call(content);
    }
}

