/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.Assignment;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.ConditionalBuilder;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.For;
import com.google.template.soy.jssrc.dsl.ForOf;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.LeafStatement;
import com.google.template.soy.jssrc.dsl.Return;
import com.google.template.soy.jssrc.dsl.StatementList;
import com.google.template.soy.jssrc.dsl.SwitchBuilder;
import com.google.template.soy.jssrc.dsl.Throw;

@Immutable
public abstract class Statement
extends CodeChunk {
    Statement() {
    }

    public static Statement of(Statement first, Statement ... rest) {
        return Statement.of((Iterable<Statement>)ImmutableList.builder().add((Object)first).add((Object[])rest).build());
    }

    public static Statement of(Iterable<Statement> stmts) {
        ImmutableList copy = ImmutableList.copyOf(stmts);
        return copy.size() == 1 ? (Statement)copy.get(0) : StatementList.create((Iterable<? extends Statement>)copy);
    }

    public static ConditionalBuilder ifStatement(Expression predicate, Statement consequent) {
        return new ConditionalBuilder(predicate, consequent);
    }

    public static Statement assign(Expression lhs, Expression rhs) {
        return Assignment.create(lhs, rhs, null);
    }

    public static Statement assign(Expression lhs, Expression rhs, JsDoc jsDoc) {
        return Assignment.create(lhs, rhs, jsDoc);
    }

    public static SwitchBuilder switchValue(Expression switchOn) {
        return new SwitchBuilder(switchOn);
    }

    public static Statement forLoop(String localVar, Expression initial, Expression limit, Expression increment, Statement body) {
        return For.create(localVar, initial, limit, increment, body);
    }

    public static Statement forOf(String localVar, Expression collection, Statement body) {
        return ForOf.create(localVar, collection, body);
    }

    public static Statement forLoop(String localVar, Expression limit, Statement body) {
        return For.create(localVar, Expression.number(0L), limit, Expression.number(1L), body);
    }

    public static Statement returnValue(Expression returnValue) {
        return Return.create(returnValue);
    }

    public static Statement returnNothing() {
        return Return.create();
    }

    public static Statement throwValue(Expression throwValue) {
        return Throw.create(throwValue);
    }

    public static Statement treatRawStringAsStatementLegacyOnly(String rawString, Iterable<GoogRequire> requires) {
        return LeafStatement.create(rawString, requires);
    }
}

