/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_GoogRequire;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.dsl.VariableReference;

@Immutable
@AutoValue
public abstract class GoogRequire
implements Comparable<GoogRequire> {
    private static final Expression GOOG_REQUIRE = Expression.dottedIdNoRequire("goog.require");
    private static final Expression GOOG_REQUIRE_TYPE = Expression.dottedIdNoRequire("goog.requireType");

    public static GoogRequire create(String symbol) {
        return new AutoValue_GoogRequire(symbol, symbol, GOOG_REQUIRE.call(Expression.stringLiteral(symbol)), false);
    }

    public static GoogRequire createTypeRequire(String symbol) {
        return new AutoValue_GoogRequire(symbol, symbol, GOOG_REQUIRE_TYPE.call(Expression.stringLiteral(symbol)), true);
    }

    public static GoogRequire createWithAlias(String symbol, String alias) {
        CodeChunkUtils.checkId(alias);
        return new AutoValue_GoogRequire(symbol, alias, VariableDeclaration.builder(alias).setRhs(GOOG_REQUIRE.call(Expression.stringLiteral(symbol))).build(), false);
    }

    public static GoogRequire createTypeRequireWithAlias(String symbol, String alias) {
        CodeChunkUtils.checkId(alias);
        return new AutoValue_GoogRequire(symbol, alias, VariableDeclaration.builder(alias).setRhs(GOOG_REQUIRE_TYPE.call(Expression.stringLiteral(symbol))).build(), true);
    }

    public abstract String symbol();

    public abstract String alias();

    abstract CodeChunk chunk();

    abstract boolean isTypeRequire();

    public Expression reference() {
        if (this.chunk() instanceof VariableDeclaration) {
            return Expression.id(((VariableDeclaration)this.chunk()).varName(), (Iterable<GoogRequire>)ImmutableSet.of((Object)this));
        }
        return Expression.dottedIdWithRequires(this.symbol(), (Iterable<GoogRequire>)ImmutableSet.of((Object)this));
    }

    public Expression googModuleGet() {
        if (this.chunk() instanceof VariableDeclaration) {
            throw new IllegalStateException("requires with aliases shouldn't use goog.module.get");
        }
        return Expression.dottedIdWithRequires("goog.module.get", (Iterable<GoogRequire>)ImmutableSet.of((Object)this)).call(Expression.stringLiteral(this.symbol()));
    }

    public Expression dotAccess(String ident) {
        return this.reference().dotAccess(ident);
    }

    public void writeTo(StringBuilder sb) {
        sb.append(this.chunk().getStatementsForInsertingIntoForeignCodeAtIndent(0));
    }

    public GoogRequire merge(GoogRequire other) {
        Preconditions.checkArgument((boolean)other.symbol().equals(this.symbol()));
        if (other.equals(this)) {
            return this;
        }
        if (other.chunk() instanceof VariableDeclaration && this.chunk() instanceof VariableDeclaration && ((VariableDeclaration)this.chunk()).varName().equals(((VariableDeclaration)other.chunk()).varName()) || !(this.chunk() instanceof VariableReference) && !(other.chunk() instanceof VariableDeclaration)) {
            if (other.isTypeRequire()) {
                return this;
            }
            return other;
        }
        throw new IllegalArgumentException("Found the same namespace added as a require in multiple incompatible ways: " + other + " vs. " + this);
    }

    @Override
    public final int compareTo(GoogRequire o) {
        return this.symbol().compareTo(o.symbol());
    }
}

