/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.JsDoc;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.annotation.Nullable;

final class FormattingContext
implements AutoCloseable {
    private final StringBuilder buf;
    private final int initialSize;
    private Scope curScope = new Scope(null, false);
    private String curIndent;
    private boolean nextAppendShouldStartNewLine = false;

    FormattingContext() {
        this(0);
    }

    FormattingContext(int startingIndent) {
        this.curIndent = Strings.repeat((String)" ", (int)startingIndent);
        this.buf = new StringBuilder(this.curIndent);
        this.initialSize = this.curIndent.length();
    }

    FormattingContext append(String stuff) {
        this.maybeIndent();
        this.buf.append(stuff);
        return this;
    }

    FormattingContext append(char c) {
        this.maybeIndent();
        this.buf.append(c);
        return this;
    }

    FormattingContext append(JsDoc jsDoc) {
        jsDoc.doFormatJsDoc(this);
        return this;
    }

    FormattingContext appendInitialStatements(CodeChunk chunk) {
        if (this.shouldFormat(chunk)) {
            chunk.doFormatInitialStatements(this);
        }
        return this;
    }

    FormattingContext appendOutputExpression(Expression value) {
        value.doFormatOutputExpr(this);
        return this;
    }

    FormattingContext appendAll(CodeChunk chunk) {
        this.appendInitialStatements(chunk);
        if (chunk instanceof Expression) {
            this.appendOutputExpression((Expression)chunk);
            this.append(";");
            this.endLine();
        }
        return this;
    }

    private boolean shouldFormat(CodeChunk chunk) {
        boolean shouldFormat;
        boolean bl = shouldFormat = !this.curScope.alreadyFormatted(chunk);
        if (shouldFormat) {
            this.curScope.formatted.add(chunk);
        }
        return shouldFormat;
    }

    FormattingContext enterBlock() {
        this.maybeIndent();
        this.buf.append('{');
        this.increaseIndent();
        this.endLine();
        this.curScope = new Scope(this.curScope, true);
        return this;
    }

    FormattingContext enterCaseBody() {
        this.maybeIndent();
        this.increaseIndent();
        this.endLine();
        this.curScope = new Scope(this.curScope, false);
        return this;
    }

    FormattingContext endLine() {
        this.nextAppendShouldStartNewLine = true;
        return this;
    }

    private void maybeIndent() {
        if (this.nextAppendShouldStartNewLine) {
            this.buf.append('\n').append(this.curIndent);
            this.nextAppendShouldStartNewLine = false;
        }
    }

    FormattingContext increaseIndent(int numIndents) {
        for (int i = 0; i < numIndents; ++i) {
            this.curIndent = this.curIndent + "  ";
        }
        return this;
    }

    FormattingContext increaseIndent() {
        return this.increaseIndent(1);
    }

    FormattingContext decreaseIndent(int numIndents) {
        for (int i = 0; i < numIndents; ++i) {
            Preconditions.checkState((!this.curIndent.isEmpty() ? 1 : 0) != 0);
            this.curIndent = this.curIndent.substring(2);
        }
        return this;
    }

    FormattingContext decreaseIndent() {
        return this.decreaseIndent(1);
    }

    public String toString() {
        return this.isEmpty() ? "" : this.buf.toString();
    }

    boolean isEmpty() {
        return this.buf.length() == this.initialSize;
    }

    @Override
    public void close() {
        boolean emitClosingBrace = this.curScope.emitClosingBrace;
        this.curScope = (Scope)Preconditions.checkNotNull((Object)this.curScope.parent);
        this.decreaseIndent();
        this.endLine();
        if (emitClosingBrace) {
            this.append('}');
        }
    }

    FormattingContext concat(FormattingContext other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        this.curIndent = "";
        return this.append(other.toString());
    }

    private static final class Scope {
        final Set<CodeChunk> formatted = Collections.newSetFromMap(new IdentityHashMap());
        @Nullable
        final Scope parent;
        final boolean emitClosingBrace;

        Scope(@Nullable Scope parent, boolean emitClosingBrace) {
            this.parent = parent;
            this.emitClosingBrace = emitClosingBrace;
        }

        boolean alreadyFormatted(CodeChunk chunk) {
            return this.formatted.contains(chunk) || this.parent != null && this.parent.alreadyFormatted(chunk);
        }
    }
}

